VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.1#0"; "mscomctl.OCX"
Begin VB.UserControl SPA_Navig 
   ClientHeight    =   9870
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   15255
   ScaleHeight     =   9870
   ScaleWidth      =   15255
   Begin VB.Frame fra_MainItem 
      Height          =   9615
      Left            =   120
      TabIndex        =   0
      Top             =   0
      Width           =   15015
      Begin VB.Frame frm_grdFilters 
         Caption         =   "#Grid filters"
         Height          =   1530
         Left            =   4095
         TabIndex        =   19
         Tag             =   "frm_grdFilters"
         Top             =   1005
         Visible         =   0   'False
         Width           =   10860
         Begin VB.TextBox txt_itemNb 
            Height          =   330
            Left            =   8490
            MaxLength       =   20
            TabIndex        =   33
            Text            =   "000000"
            Top             =   262
            Width           =   2205
         End
         Begin VB.TextBox txt_SPAID 
            Height          =   330
            Left            =   5505
            MaxLength       =   6
            TabIndex        =   31
            Text            =   "000000"
            Top             =   262
            Width           =   720
         End
         Begin VB.TextBox txt_custName 
            Height          =   330
            Left            =   1785
            TabIndex        =   29
            Text            =   "Text1"
            Top             =   262
            Width           =   2565
         End
         Begin VB.CommandButton btn_applyFilters 
            Caption         =   "#Apply filters"
            Height          =   345
            Left            =   9405
            TabIndex        =   27
            Tag             =   "btn_applyFilters"
            Top             =   675
            Width           =   1335
         End
         Begin VB.CommandButton btn_hideFilters 
            Caption         =   "#Hide filters"
            Height          =   345
            Left            =   9405
            TabIndex        =   26
            Tag             =   "btn_hideFilters"
            Top             =   1080
            Width           =   1335
         End
         Begin VB.TextBox txt_comment 
            Height          =   480
            Left            =   4470
            MultiLine       =   -1  'True
            TabIndex        =   25
            Tag             =   "txt_comment"
            Text            =   "SPA_Navig.ctx":0000
            Top             =   915
            Width           =   4815
         End
         Begin Project1.ArmCombobox cbo_CCU_Town 
            Height          =   345
            Left            =   1785
            TabIndex        =   20
            Tag             =   "cbo_CCU_Town"
            Top             =   645
            Width           =   2565
            _ExtentX        =   4524
            _ExtentY        =   609
         End
         Begin Project1.ArmCombobox cbo_project 
            Height          =   345
            Left            =   1785
            TabIndex        =   23
            Tag             =   "cbo_project"
            Top             =   1050
            Width           =   2565
            _ExtentX        =   4524
            _ExtentY        =   609
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#Item nb."
            Height          =   255
            Index           =   7
            Left            =   7095
            TabIndex        =   32
            Tag             =   "lbl_ITEMNB"
            Top             =   300
            Width           =   1335
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#SPA ID"
            Height          =   255
            Index           =   6
            Left            =   4440
            TabIndex        =   30
            Tag             =   "lbl_SPA_ID"
            Top             =   300
            Width           =   1020
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#Customer name"
            Height          =   255
            Index           =   5
            Left            =   120
            TabIndex        =   28
            Tag             =   "lbl_CustomerName"
            Top             =   300
            Width           =   1590
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#Comment containt"
            Height          =   255
            Index           =   4
            Left            =   4470
            TabIndex        =   24
            Tag             =   "lbl_comment"
            Top             =   675
            Width           =   3165
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#Project"
            Height          =   255
            Index           =   3
            Left            =   120
            TabIndex        =   22
            Tag             =   "lbl_project"
            Top             =   1065
            Width           =   1590
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#Customer town"
            Height          =   255
            Index           =   2
            Left            =   120
            TabIndex        =   21
            Tag             =   "lbl_CustomerTown"
            Top             =   705
            Width           =   1590
         End
      End
      Begin VB.CommandButton cmd_TVReLoad 
         Height          =   735
         Left            =   0
         Style           =   1  'Graphical
         TabIndex        =   9
         Tag             =   "cmd_TVReLoad"
         Top             =   3480
         Visible         =   0   'False
         Width           =   735
      End
      Begin VB.PictureBox pic_filtersReset 
         Appearance      =   0  'Flat
         AutoSize        =   -1  'True
         BackColor       =   &H80000005&
         BorderStyle     =   0  'None
         ForeColor       =   &H80000008&
         Height          =   240
         Left            =   -30
         Picture         =   "SPA_Navig.ctx":000C
         ScaleHeight     =   16
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   16
         TabIndex        =   15
         Top             =   90
         Width           =   240
      End
      Begin VB.Frame fra_MainFilter 
         Height          =   2865
         Left            =   105
         TabIndex        =   12
         Top             =   120
         Width           =   3855
         Begin VB.CheckBox chk_usedBySAP 
            Caption         =   "Not used by SAP"
            Height          =   375
            Left            =   120
            TabIndex        =   2
            Tag             =   "chk_UsedBySAP"
            Top             =   840
            Value           =   1  'Checked
            Width           =   3615
         End
         Begin VB.OptionButton opt_FilterDate 
            Caption         =   "#Between"
            Height          =   255
            Index           =   1
            Left            =   2160
            TabIndex        =   4
            Tag             =   "opt_between"
            Top             =   1605
            Width           =   1575
         End
         Begin VB.OptionButton opt_FilterDate 
            Caption         =   "#All"
            Height          =   255
            Index           =   0
            Left            =   75
            TabIndex        =   3
            Tag             =   "opt_all"
            Top             =   1590
            Value           =   -1  'True
            Width           =   1800
         End
         Begin Project1.A_calocx cal12 
            Height          =   375
            Left            =   1920
            TabIndex        =   7
            Tag             =   "Date_To"
            Top             =   2370
            Visible         =   0   'False
            Width           =   1815
            _ExtentX        =   3201
            _ExtentY        =   661
         End
         Begin Project1.A_calocx cal11 
            Height          =   375
            Left            =   120
            TabIndex        =   6
            Tag             =   "Date_From"
            Top             =   2370
            Visible         =   0   'False
            Width           =   1815
            _ExtentX        =   3201
            _ExtentY        =   661
         End
         Begin MSComctlLib.TabStrip tbs_Status 
            Height          =   410
            Left            =   60
            TabIndex        =   1
            Tag             =   "FilterStatus"
            Top             =   360
            Width           =   3690
            _ExtentX        =   6509
            _ExtentY        =   714
            MultiRow        =   -1  'True
            Style           =   1
            Placement       =   1
            _Version        =   393216
            BeginProperty Tabs {1EFB6598-857C-11D1-B16A-00C0F0283628} 
               NumTabs         =   4
               BeginProperty Tab1 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
                  Caption         =   "#All"
                  Key             =   "All"
                  Object.Tag             =   "tbs_SPA_statusAll"
                  ImageVarType    =   2
               EndProperty
               BeginProperty Tab2 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
                  Caption         =   "#Completed"
                  Key             =   "Completed"
                  Object.Tag             =   "tbs_SPA_statusCompleted"
                  ImageVarType    =   2
               EndProperty
               BeginProperty Tab3 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
                  Caption         =   "#Active"
                  Key             =   "Active"
                  Object.Tag             =   "tbs_SPA_statusActive"
                  ImageVarType    =   2
               EndProperty
               BeginProperty Tab4 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
                  Caption         =   "#Not required"
                  Key             =   "NotRequired"
                  Object.Tag             =   "tbs_SPA_statusNotRequired"
                  ImageVarType    =   2
               EndProperty
            EndProperty
         End
         Begin Project1.ArmCombobox cbo_Date_Type 
            Height          =   345
            Left            =   120
            TabIndex        =   5
            Tag             =   "cbo_Date_Type"
            Top             =   1920
            Visible         =   0   'False
            Width           =   3615
            _ExtentX        =   6376
            _ExtentY        =   609
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#Data range"
            Height          =   255
            Index           =   1
            Left            =   75
            TabIndex        =   14
            Tag             =   "lbl_DataRange"
            Top             =   1275
            Width           =   1215
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#SPA_Status"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   13
            Tag             =   "lbl_SPA_Status"
            Top             =   180
            Width           =   1215
         End
      End
      Begin MSComctlLib.TabStrip tbs_ProjectType 
         Height          =   375
         Left            =   120
         TabIndex        =   11
         Tag             =   "ProjectType"
         Top             =   9120
         Width           =   3855
         _ExtentX        =   6800
         _ExtentY        =   661
         MultiRow        =   -1  'True
         Placement       =   1
         _Version        =   393216
         BeginProperty Tabs {1EFB6598-857C-11D1-B16A-00C0F0283628} 
            NumTabs         =   3
            BeginProperty Tab1 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
               Caption         =   "#All"
               Key             =   "All"
               Object.Tag             =   "tbs_SPA_TypeAll"
               ImageVarType    =   2
            EndProperty
            BeginProperty Tab2 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
               Caption         =   "#Stock"
               Key             =   "Stock"
               Object.Tag             =   "tbs_SPA_TypeStock"
               ImageVarType    =   2
            EndProperty
            BeginProperty Tab3 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
               Caption         =   "#Project"
               Key             =   "Project"
               Object.Tag             =   "tbs_SPA_TypeProject"
               ImageVarType    =   2
            EndProperty
         EndProperty
      End
      Begin Project1.ArmCombobox cbo_View 
         Height          =   345
         Left            =   120
         TabIndex        =   8
         Tag             =   "cbo_View"
         Top             =   3120
         Width           =   3870
         _ExtentX        =   6826
         _ExtentY        =   609
      End
      Begin Project1.ArmGrid grd_Main 
         Height          =   4590
         Left            =   4080
         TabIndex        =   16
         TabStop         =   0   'False
         Tag             =   "grd_Main"
         Top             =   2595
         Width           =   10860
         _ExtentX        =   19156
         _ExtentY        =   8096
      End
      Begin Project1.ArmTreeView tvw_Main 
         Height          =   5520
         Left            =   90
         TabIndex        =   10
         Top             =   3525
         Width           =   3825
         _ExtentX        =   6747
         _ExtentY        =   9737
      End
      Begin Project1.ToolbarControl tlb_Main 
         Height          =   690
         Left            =   4080
         TabIndex        =   17
         TabStop         =   0   'False
         Top             =   240
         Width           =   10725
         _ExtentX        =   18918
         _ExtentY        =   1217
      End
      Begin Project1.ArmGrid grd_SPA_Detail 
         Height          =   2205
         Left            =   4080
         TabIndex        =   18
         TabStop         =   0   'False
         Tag             =   "grd_Detail"
         Top             =   7320
         Width           =   10860
         _ExtentX        =   19156
         _ExtentY        =   3889
      End
   End
End
Attribute VB_Name = "SPA_Navig"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'what is new
'2.7.1 : internal comment column added (JN)
'2.7.1 : New filters on grid search (JN)
'4.0.0 : Column contractor swapped with internal commment (JN)

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK API FUNCTION DECLARES
'**********************************************************************************************************************************
'**********************************************************************************************************************************
Private Declare Function GetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long
Private Declare Function GetSystemDefaultLCID Lib "kernel32" () As Long
Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function LoadLibrary Lib "kernel32" Alias "LoadLibraryA" _
   (ByVal lpLibFileName As String) As Long
Private Declare Function FreeLibrary Lib "kernel32" (ByVal hLibModule As Long) As Long
Private Declare Function LoadIconFromDLL Lib "user32" Alias "LoadIconA" (ByVal hInstance As Long, ByVal lpIconName As Long) As Long
Private Declare Function OleCreatePictureIndirect Lib "olepro32.dll" (lpPictDesc As PictDesc, riid As Guid, ByVal fPictureOwnsHandle As Long, ipic As IPicture) As Long
Private Declare Function GetTempPath Lib "kernel32" Alias "GetTempPathA" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK CONSTANTS
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Const SEP = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private Const SCREEN_NAME As String = "SPA_Navig"

Private Const LOCALE_USER_DEFAULT = &H400
Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator

Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const CL_COLOR_LOCKED As Long = &H80000018
Private Const C_ERRORRAISE As Long = 8000
Private Const ICON_RELOAD = 115
Private Const FRM_SPACE_VER = 120
Private Const FRM_SPACE_HOR = 100
Private Const STATUS_COLUMN = "Status"

'**********************************************************************************************************************************

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK VARIABLES
'**********************************************************************************************************************************
'**********************************************************************************************************************************


#If LIVE = 1 Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

#If LIVE = 1 Then
    Dim mo_FSO As Object
#Else
    Dim mo_FSO As Scripting.FileSystemObject
#End If

Private ms_Language_Code                As String       'current user interface language
Private ml_U_Code                       As Long         'U_Code (GEN_Systems_Users) of logged user
Private ms_LoginName                    As String       'contain loginname
Private ms_UserName                     As String       'contain name of logged user as defined in GEN_People
Private mb_InternalInit                 As Boolean      'framework is doing some own control manipulation, all events should handle
Private mb_Initialized                  As Boolean      'framework is initialised or not
Private ms_DecimalSeparator             As String       'locale decimal separator
Private ms_ThousandSeparator            As String       'locale thousand separator
Private ms_Title                        As String       'title of user control - can be assigned as Caption to the parent form or title for printing
Private mt_MainConfig                   As TMainConfig
Private mc_Toolbars                     As Long         'cursor which will contain all toolbars for current usercontrol
Private ms_ToolbarRequest               As String       'request which load all toolbars for current usercontrol
Private mc_ScreenLabels                 As Long         'cursor containing screen constants for current component
Private mb_filtersVisible               As Boolean      'if grid filters are visible

Private WithEvents mo_SPA_MAIN          As SPA_Main
Attribute mo_SPA_MAIN.VB_VarHelpID = -1
Private mo_userRghts                    As TSPAUserRights

'**********************************************************************************************************************************

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK CUSTOM TYPES
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Type PictDesc
    cbSizeofStruct As Long
    picType As Long
    hImage As Long
    xExt As Long
    yExt As Long
End Type

Private Type Guid
    Data1 As Long
    Data2 As Integer
    Data3 As Integer
    Data4(0 To 7) As Byte
End Type

Private Type TTreeViewInfo
    Levels As Long
    NodeRequest() As String
    GridRequest() As String
    ExcelRequest() As String
    CountRequest() As String
    FindRequest() As String
    Images() As Integer
    SelectedImages() As Integer
    TreeViewCode As String
    Loaded As Boolean
End Type

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
    InvalidValue = C_ERRORRAISE + 12            ' load function failed ... bad sql
    ErrMsg_M130 = C_ERRORRAISE + 130            'You cannot email this SPA because the status is not APPROVED
    ErrMsg_M150 = C_ERRORRAISE + 150            'This email address does not appear to be the correct format (User@domain)
    ErrMsg_M730 = C_ERRORRAISE + 730            'The length of address cannot be more than 80 characters
    ErrMsg_M310 = C_ERRORRAISE + 310            'You are at the first Item in the list
    ErrMsg_M320 = C_ERRORRAISE + 320            'You are at the last item in the list

End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
    WarMsgSelectRow = 2304
End Enum

Private Type TMainConfig
    NameFrame                       As String
    ViewCode                        As String
    FrameIndex                      As Long
    IsMultiDetailView               As Boolean
    Initialized                     As Boolean
    ToolbarFace                     As String
    ToolbarIndex                    As Long
    ToolbarID                       As Long
    CurrentTvwSelMethod             As eTvwSelMethod
    GridDelayMethod                 As eGridLoadMethod
    GridDelayed                     As Boolean
    TreeDelayed                     As Boolean
    mTreeViewInfos()                As TTreeViewInfo
    MainGridColumns                 As Variant
    SubGridColumns                 As Variant
    ActiveDetailControl             As Object
    HasTreeview                     As Boolean
    GridRequest                     As String
End Type

Private Enum eMode
    emNone
    emList
    emView
    emAdd
    emUpdate
    emDelete
End Enum

Private Enum eControlPropertyIndex
    cpiControl
    cpiTag
    cpiVisible
    cpiRequest
End Enum

Private Enum eControlAction
    caDoubleClick
    caClick
    caSelect
    caLoad
End Enum

' The different way to select data in the treeview
Private Enum eTvwSelMethod
    etmNone = 0
    etmNode = 1         ' User click on the last node of a branch
    etmBranch = 2       ' User click on a branch and use the load button
    etmCheckBoxes = 3   ' User click on the load button when checkboxes mode is set
End Enum

Private Enum eGridLoadMethod
    egmDelayedAlways = 0
    egmDelayedExceptLastLevel = 1
    egmLoadAlways = 2
End Enum


'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK EVENTS
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Event quit()

'**********************************************************************************************************************************

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK INTERFACE AND PROPERTIES
' please DO NOT change anything in this part of code
'**********************************************************************************************************************************
'**********************************************************************************************************************************
Public Property Let Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
End Property
Public Property Get Visible() As Boolean
    Visible = UserControl.Extender.Visible
End Property
Public Property Let Top(ByVal aTop As Single)
    UserControl.Extender.Top = aTop
End Property
Public Property Get Top() As Single
    Top = UserControl.Extender.Top
End Property
Public Property Let Height(ByVal aHeight As Single)
    UserControl.Extender.Height = aHeight
End Property
Public Property Get Height() As Single
    Height = UserControl.Extender.Height
End Property
Public Property Let Left(ByVal aLeft As Single)
    UserControl.Extender.Left = aLeft
End Property
Public Property Get Left() As Single
    Left = UserControl.Extender.Left
End Property
Public Property Let Width(ByVal aWidth As Single)
    UserControl.Extender.Width = aWidth
End Property
Public Property Get Width() As Single
    Width = UserControl.Extender.Width
End Property
Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
End Sub
Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property
Public Property Get Title() As String
    Title = ms_Title
End Property
Public Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    
    ml_U_Code = al_U_Code
    Exit Property
ErrHandler:
    Call ErrorHandler("U_Code(Let)")
End Property

Public Property Let LoginName(ByVal as_LoginName As String)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    
    ms_LoginName = as_LoginName
    Exit Property
ErrHandler:
    Call ErrorHandler("LoginName(Let)")
End Property

Public Property Let Language_Code(as_Language_Code As String)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If Len(as_Language_Code) <> 1 Then Call Err.Raise(ArmErr.InvalidArgument, "", "Language_code must contains only 1 char")
    
    ms_Language_Code = as_Language_Code
    Exit Property
ErrHandler:
    Call ErrorHandler("Language(Let)")
End Property

Public Property Set DB(ByRef ao_DB As ArmDb)
On Error GoTo ErrHandler
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If ao_DB Is Nothing Then Call Err.Raise(ArmErr.InvalidArgument)
    
    Set mo_Db = ao_DB
    Exit Property
ErrHandler:
    Call ErrorHandler("Db(Set)")
End Property


'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK METHODS
' please DO NOT change anything in this part of code
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Function AddNewTab(ByRef ao_TabStrip As MSComctlLib.TabStrip, ByVal as_Key As String, ByVal as_Tag As String, ByVal as_caption As String) As Object
On Error GoTo ErrHandler
    Dim lo_retTab As Object
    If (ao_TabStrip.Tabs.Count = 1) And (ao_TabStrip.Tabs(1).Tag = "") Then
        Set lo_retTab = ao_TabStrip.Tabs(1)
        lo_retTab.Key = as_Key
        lo_retTab.Tag = as_Tag
        lo_retTab.Caption = as_caption
    Else
        Set lo_retTab = ao_TabStrip.Tabs.Add(, as_Key, as_caption)
        lo_retTab.Tag = as_Tag
    End If

    Set AddNewTab = lo_retTab
    Exit Function
ErrHandler:
    Call ErrorHandler("AddNewTab")
End Function

Private Sub Load_ConfigInfo()
On Error GoTo ErrHandler

    mt_MainConfig.GridDelayMethod = egmDelayedExceptLastLevel
    Set mt_MainConfig.ActiveDetailControl = Nothing
    mt_MainConfig.HasTreeview = True
    
    grd_SPA_Detail.AllowExcelExport = False
    grd_SPA_Detail.FreeSelect = False
    grd_SPA_Detail.AllowSort = False
    grd_SPA_Detail.Title = "#Items"
    grd_SPA_Detail.ExportOnlyVisibleColumns = True
    
    
    grd_main.AllowExcelExport = True
    grd_main.ExportTitles = True
    grd_main.Title = "#Special price requests"
    grd_main.ExportOnlyVisibleColumns = True

    With mt_MainConfig
        .FrameIndex = 0
        .IsMultiDetailView = False
        .Initialized = False
        .NameFrame = "SPA_Main"
        .ViewCode = "SPA_Main"
        .ToolbarFace = "0"
        .ToolbarIndex = 0
        .ToolbarID = TLB_SPA_MAIN_ID
        .MainGridColumns = Array( _
            "SPA_Id6001SPA_Id#SPA_Id", _
            "Z_creation9000Z_creation#Z_creationDate", _
            "CCU_Desc10000CCU_Desc#Customer", _
            "CCU_Town10000CCU_Town#Town", _
            "Internal_comment10000Internal_comment#Internal_comment", _
            "RF_Desc10000RF_Desc#Type", _
            "Date_Required9000Date_Required#Required", _
            "Raised_For_U_Name10000Raised_For_U_Name#Requestor", _
            "SPA_Used_Comment10000SPA_Used_Comment#SPA_Used_Comment", _
            "RF_Status10000RF_Status#Status", _
            "SP_Desc10000SP_Desc#Project", _
            "Date_Sent9000Date_Sent#Date_SentDate", _
            "CC_CCU_Desc10000CC_CCU_Desc#Contractor", _
            "CT_Code00CT_Code#CT_Code", _
            "SPM_Code00SPM_Code#SPM_Code", _
            "Email00Email#Email", _
            "SPA_ApprovalStatus00SPA_ApprovalStatus#SPA_ApprovalStatus" _
            )   ' P.16
            
        ' 16.4. JN - fix to display 4 deciml places for Std_price
        .SubGridColumns = Array( _
                "BI_SAP_Code6001BI_SAP_Code#SAP Code", _
                "BI_Desc17000BI_Desc#Prod Desc", _
                "SPA_Qty10000SPA_Qty#QuantityFloat" & QTY_FORMAT, _
                "SPA_UoM10000SPA_UoM#UOM", _
                "Std_Price10000Std_Price#PriceFloat" & MONEY_FORMAT_PRECISE & "Left", _
                "SPA_Price10000SPA_Price#Requested priceFloat" & MONEY_FORMAT & "Left", _
                "SPA_CURR_Code15000SPA_CURR_Code#CurrencyStringLeft", _
                "SPA_Discount10000SPA_Discount#DiscountFloat" & PERCENT_FORMAT & "Left", _
                "SPI_RebateExempt20000SPI_RebateExempt#Rebate ExemptStringLeft")
    End With
    
    If mt_MainConfig.HasTreeview Then
        cmd_TVReLoad.Picture = LoadIconFromA_Icons(ICON_RELOAD)
        Call SetTreeDelayedMode(False)
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("Load_ConfigInfo")
End Sub
    
Private Function tlb_Main_CustomAction(ByVal as_Role As String, as_Language As String) As Boolean
On Error GoTo ErrHandler
    tlb_Main_CustomAction = False
    Exit Function
ErrHandler:
    Call ErrorHandler("tlb_Main_CustomAction")
End Function

Private Function grd_Main_CustomAction(ByVal ae_Action As eControlAction) As Boolean
On Error GoTo ErrHandler
    
    Call InitDetailControl
    
    Select Case ae_Action
        Case eControlAction.caDoubleClick
        ' load detail
        If Not mt_MainConfig.ActiveDetailControl Is Nothing Then
            Call mt_MainConfig.ActiveDetailControl.Run(SPA_Mode.emView, grd_main.CurrentKey)
            mt_MainConfig.ActiveDetailControl.Visible = True
        End If
    Case Else
        Debug.Assert (False)
    End Select

    grd_Main_CustomAction = True
    Exit Function
ErrHandler:
    Call ErrorHandler("grd_Main_CustomAction")
End Function

Private Function Resize_Custom() As Boolean
On Error GoTo ErrHandler

    Resize_Custom = False
    Exit Function
ErrHandler:
    Call ErrorHandler("Resize_Custom")
End Function

Private Function IsItemInFilterCustom(ByRef ao_data As Dictionary, ByRef ab_CheckDone As Boolean) As Boolean
On Error GoTo ErrHandler
    ab_CheckDone = False
    IsItemInFilterCustom = False
    Dim lb_retVal As Boolean
    lb_retVal = False
    
    ' 1. check task_User tab .... All/My task/responsible task
    Dim ll_ApprovalStatus As Long
    ll_ApprovalStatus = ao_data.Item("SPA_ApprovalStatus")
    Select Case tbs_Status.SelectedItem.Key
        Case "All"
            lb_retVal = True
        Case "Completed" ' SPA.SPA_ApprovalStatus IN (4,2,3)    -- Not required, authorised, rejected
            lb_retVal = (ll_ApprovalStatus = 4 Or ll_ApprovalStatus = 2 Or ll_ApprovalStatus = 3)
        Case "Active"    '  SPA.SPA_ApprovalStatus IN (1,5)     -- new, submitted
            lb_retVal = (ll_ApprovalStatus = 1 Or ll_ApprovalStatus = 5)
        Case "NotRequired" 'SPA.SPA_ApprovalStatus = 4     -- not required
            lb_retVal = (ll_ApprovalStatus = 4)
        Case Else
            Debug.Print ("IsItemInFilterCustom: unknown tbs_Status")
    End Select
        
    ' 2. check date range .... All/Between
    If lb_retVal Then
        If opt_FilterDate(1).Value Then
            Dim ld_from As Date, ld_to As Date, ld_Date_Completed As Date, ld_Date_Submitted As Date, ld_Date_Required As Date, ld_Z_Creation As Date
            
            If cal11.date_dt = 0 Then
                ld_from = 1
            Else
                ld_from = cal11.date_dt
            End If
            
            If cal12.date_dt = 0 Then
                ld_to = 999999
            Else
                ld_to = cal12.date_dt
            End If
            
            If IsDate(ao_data.Item("Date_Completed")) Then
                ld_Date_Completed = CDate(ao_data.Item("Date_Completed"))
            Else
                ld_Date_Completed = 0
            End If
            
            If IsDate(ao_data.Item("Date_Submitted")) Then
                ld_Date_Submitted = CDate(ao_data.Item("Date_Submitted"))
            Else
                ld_Date_Submitted = 0
            End If
            
            If IsDate(ao_data.Item("Date_Required")) Then
                ld_Date_Required = CDate(ao_data.Item("Date_Required"))
            Else
                ld_Date_Required = 0
            End If
            
            If IsDate(ao_data.Item("Z_Creation")) Then
                ld_Z_Creation = CDate(ao_data.Item("Z_Creation"))
            Else
                ld_Z_Creation = 0
            End If
            
            Select Case GetComboKey(cbo_Date_Type)
                Case "1" ' Date_Completed   ... @Date_From IS NULL OR SPA.Date_Completed >= @Date_From) AND (@Date_To IS NULL OR SPA.Date_Completed <= @Date_To)
                    lb_retVal = (ld_Date_Completed >= ld_from And ld_Date_Completed <= ld_to)
                Case "2" ' Date_Raised      ... @Date_From IS NULL OR SPA.Date_Submitted >= @Date_From) AND (@Date_To IS NULL OR SPA.Date_Submitted <= @Date_To)
                    lb_retVal = (ld_Date_Submitted >= ld_from And ld_Date_Submitted <= ld_to)
                Case "3" ' Date_Required    ... @Date_From IS NULL OR SPA.Date_Required >= @Date_From) AND (@Date_To IS NULL OR SPA.Date_Required <= @Date_To)
                    lb_retVal = (ld_Date_Required >= ld_from And ld_Date_Required <= ld_to)
                Case "4" ' Z_Creation       ... @Date_From IS NULL OR SPA.Z_Creation >= @Date_From) AND (@Date_To IS NULL OR SPA.Z_Creation <= @Date_To)
                    lb_retVal = (ld_Z_Creation >= ld_from And ld_Z_Creation <= ld_to)
                Case Else
                    Debug.Print ("IsItemInFilterCustom: unknown cbo_Date_Type")
            End Select
        End If
    End If
    
    ' 3. check status tab .... active/completed/archived/all
    If lb_retVal Then
        Select Case tbs_ProjectType.SelectedItem.Key
            Case "Stock"                                                ' SPA_TypeFlag = 2
                lb_retVal = (ao_data.Item("SPA_TypeFlag") = 2)
            Case "Project"                                              ' SPA_TypeFlag = 1
                lb_retVal = (ao_data.Item("SPA_TypeFlag") = 1)
            Case "All"
            Case Else
                Debug.Print ("IsItemInFilterCustom: unknown tbs_ProjectType")
        End Select
    End If
    
    ' chk_usedBySAP ... not used in SAP
    If lb_retVal Then
        If chk_usedBySAP.Value = 1 Then
            lb_retVal = (ao_data.Item("SPA_Used_Flag") <> "X")
        Else
            lb_retVal = (ao_data.Item("SPA_Used_Flag") = "X")
        End If
    End If
    
    ab_CheckDone = True

    IsItemInFilterCustom = lb_retVal
    Exit Function
ErrHandler:
    Call ErrorHandler("IsItemInFilterCustom")
End Function

Private Function IsItemSelectedInTreeCustom(ByVal al_DetailIndex As Long, ByRef ao_Tree As ArmTreeView, ByVal av_PathData As Variant, ByRef ab_CheckDone As Boolean) As Boolean

    IsItemSelectedInTreeCustom = False
    ab_CheckDone = False
    
    Exit Function
ErrHandler:
    Call ErrorHandler("IsItemSelectedInTreeCustom")
End Function

Private Sub SetDisabledDetailControls()
On Error GoTo ErrHandler

    Exit Sub
ErrHandler:
    Call ErrorHandler("SetDisabledDetailControls")
End Sub

Private Sub FillDataSrcArray(ByRef ao_dataSrc As Dictionary, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    
    Dim ll_i As Long
    Dim lsa_DataFields() As String
    Dim lv_Values As Variant
    lsa_DataFields = Split(as_SrzFields, SEP)
    
    For ll_i = LBound(lsa_DataFields) To UBound(lsa_DataFields)
        lv_Values = Split(lsa_DataFields(ll_i), SEP1)
        If UBound(lv_Values) >= 1 Then
            If lv_Values(0) <> "" Then
                If Not ao_dataSrc.Exists(lv_Values(0)) Then
                    If UBound(lv_Values) = 1 Then
                        Call ao_dataSrc.Add(lv_Values(0), lv_Values(1))
                    Else
                        Call ao_dataSrc.Add(lv_Values(0), lv_Values)
                    End If
                End If
            End If
        End If
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("FillDataSrcArray")
End Sub

Private Function IsInArray(ByVal as_val As String, ByRef av_Array As Variant) As Boolean
On Error GoTo ErrHandler
    Dim ll_i As Long
    IsInArray = False
    For ll_i = LBound(av_Array) To UBound(av_Array)
        If StrComp(av_Array(ll_i), as_val, vbTextCompare) <> 0 Then Exit Function
    Next
    IsInArray = True
    Exit Function
ErrHandler:
    Call ErrorHandler("IsInArray")
End Function
Private Sub DeleteLineToGrid(ByVal ao_grid As ArmGrid, ByVal av_KeyFields As Variant, ByVal al_KeyVal As Variant)
On Error GoTo ErrHandler
    
    Dim ll_Col As Long
    Dim lo_Column As ArmColumn
    Dim lba_bckKeys() As Boolean
    Dim lv_bckKey As Variant
    ReDim lba_bckKeys(0 To ao_grid.Cols - 1)
    
    ' backup keys
    lv_bckKey = ao_grid.CurrentKey
    For ll_Col = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Col)
        lba_bckKeys(ll_Col) = lo_Column.Key
        lo_Column.Key = IsInArray(lo_Column.FieldName, av_KeyFields)
    Next

    ' delete all lines
    While ao_grid.SearchKey(True, al_KeyVal)
        ao_grid.DeleteLine
    Wend
    
    ' restore keys
    For ll_Col = 0 To ao_grid.Cols - 1
        ao_grid.Columns(ll_Col).Key = lba_bckKeys(ll_Col)
    Next
    Call ao_grid.SearchKey(True, lv_bckKey)

    Exit Sub
ErrHandler:
    Call ErrorHandler("DeleteLineToGrid")
End Sub

Private Function IsKeyRow(ByVal ao_grid As ArmGrid, ByVal al_Row As Long, ByVal av_keyCols As Variant, ByRef ao_dataSrc As Dictionary) As Boolean
On Error GoTo ErrHandler
    IsKeyRow = False
    Dim ll_i As Long
    For ll_i = LBound(av_keyCols) To UBound(av_keyCols)
        If StrComp(ao_grid.Data(al_Row, av_keyCols(ll_i)), ao_dataSrc(av_keyCols(ll_i)), vbTextCompare) <> 0 Then
            Exit Function
        End If
    Next
    IsKeyRow = True
    Exit Function
ErrHandler:
    Call ErrorHandler("IsKeyRow")
End Function


Private Sub UpdateLineToGrid(ByVal ao_grid As ArmGrid, ByRef ao_dataSrc As Dictionary, ByVal av_keyCols As Variant)
On Error GoTo ErrHandler

    Debug.Assert (ao_grid.Cols > 0)
    Dim ll_Row As Long, ll_RowCount As Long, ll_Col As Long
    Dim lo_Column As ArmColumn
    
    ll_RowCount = ao_grid.Rows - 1
    For ll_Row = 0 To ll_RowCount
        If IsKeyRow(ao_grid, ll_Row, av_keyCols, ao_dataSrc) Then
            For ll_Col = 0 To ao_grid.Cols - 1
                Set lo_Column = ao_grid.Columns(ll_Col)
                If ao_dataSrc.Exists(lo_Column.FieldName) Then
                    If lo_Column.FieldType = DBTYPE_R4 Or lo_Column.FieldType = DBTYPE_R8 Then
                        Call lo_Column.SetData(ll_Row, Replace(ao_dataSrc(lo_Column.FieldName), ".", ms_DecimalSeparator))
                    Else
                        Call lo_Column.SetData(ll_Row, ao_dataSrc(lo_Column.FieldName))
                    End If
                End If
            Next
            ao_grid.LineColor(ll_Row) = COLOR_UPDLINE
        End If
    Next

    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateLineToGrid")
End Sub

Private Sub AddLineToGrid(ByVal ao_grid As ArmGrid, ByRef ao_dataSrc As Dictionary)
On Error GoTo ErrHandler
    
    ' insert row at the end of grid
    Debug.Assert (ao_grid.Cols > 0)
    Dim lo_Column As ArmColumn
    Dim ll_Index As Long
    Dim lsa_newRow() As String
    ReDim lsa_newRow(0 To ao_grid.Cols - 1)
    
    Call ao_grid.DeselectRow
    
    For ll_Index = 0 To ao_grid.Cols - 1
        Set lo_Column = ao_grid.Columns(ll_Index)
        If ao_dataSrc.Exists(lo_Column.FieldName) Then
            If lo_Column.FieldType = DBTYPE_R4 Or lo_Column.FieldType = DBTYPE_R8 Then
                lsa_newRow(ll_Index) = Replace(ao_dataSrc(lo_Column.FieldName), ".", ms_DecimalSeparator)
            Else
                lsa_newRow(ll_Index) = ao_dataSrc.Item(lo_Column.FieldName)
            End If
        Else
            lsa_newRow(ll_Index) = "TODO:"
        End If
    Next
    Call ao_grid.AddLine(lsa_newRow)
    ao_grid.LineColor(ao_grid.Row) = COLOR_ADDLINE
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("AddLineToGrid")
End Sub
Private Function GetFieldValueFromSrz(ByVal as_SrzFields As String, ByVal as_Param As String) As String
On Error GoTo ErrHandler
    
    Dim lv_SrzFields As Variant
    Dim lv_Values
    Dim ll_Count As Long
    Dim ll_Nb As Long
       
    If right(as_SrzFields, 2) <> SEP Then as_SrzFields = as_SrzFields & SEP
       
    lv_SrzFields = Split(as_SrzFields, SEP)
    ll_Nb = UBound(lv_SrzFields) - 1

    For ll_Count = 0 To ll_Nb
        lv_Values = Split(lv_SrzFields(ll_Count), SEP1)
         If UCase(as_Param) = UCase(lv_Values(0)) Then
           GetFieldValueFromSrz = lv_Values(1)
           Exit For
         End If
    Next ll_Count
    
    Exit Function
ErrHandler:
    Call ErrorHandler("GetFieldValueFromSrz")
End Function


' update toolbar according to user rights
Private Sub UpdateMainToolbar(ByRef ao_rights As TSPAUserRights)
On Error GoTo ErrHandler
    Dim lb_ITS As Boolean
    Dim lb_superUser As Boolean
    Dim lb_releaser As Boolean
    Dim lb_COS As Boolean
    Dim lb_requestor As Boolean
    Dim lb_approver As Boolean
    Dim lb_salesRepre As Boolean
    Dim lb_SAP_ErrorReciever  As Boolean
    Dim lb_ValidToUpdater As Boolean
    
    lb_ITS = isUserType(ao_rights.SPARights, SPA_ITS)
    lb_superUser = isUserType(ao_rights.SPARights, SPA_SuperUser)
    lb_releaser = isUserType(ao_rights.SPARights, SPA_Releaser)
    lb_COS = isUserType(ao_rights.SPARights, SPA_COS)
    lb_requestor = isUserType(ao_rights.SPARights, SPA_Requestor)
    lb_approver = isUserType(ao_rights.SPARights, SPA_Approver)
    lb_salesRepre = isUserType(ao_rights.SPARights, SPA_SalesRepresentative)
    lb_SAP_ErrorReciever = isUserType(ao_rights.SPARights, SAP_ErrorReciever)
    lb_ValidToUpdater = isUserType(ao_rights.SPARights, SPA_ValidToUpdater)
    
    
    tlb_main.ButtonVisible("A") = lb_ITS Or lb_superUser
    tlb_main.ButtonVisible("B") = lb_ITS Or lb_superUser
    tlb_main.ButtonVisible("C") = lb_ITS Or lb_superUser
    tlb_main.ButtonVisible("X") = lb_ITS Or lb_superUser
    tlb_main.ButtonVisible("v") = lb_ITS Or lb_superUser

    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateMainToolbar")
End Sub

' if at least for one market is defined as userType
Private Function isUserType(ByRef la_SPARights() As TSPARight, ByVal al_userType As eSPA_UserType_Code, Optional ByVal al_SPM_Code As Long = 0) As Boolean
On Error GoTo ErrHandler
    isUserType = False
    Dim ll_i As Long
    For ll_i = LBound(la_SPARights) To UBound(la_SPARights)
        If la_SPARights(ll_i).SPA_UserType_Code = al_userType Then
            If al_SPM_Code = 0 Or la_SPARights(ll_i).SPM_Code = al_SPM_Code Then
                isUserType = True
                Exit Function
            End If
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler("isUserType")
End Function

' update toolbar according to data selected
Private Sub UpdateMainToolbarCustom()
On Error GoTo ErrHandler
    Dim lb_isOwner As Boolean, lb_isCompleted As Boolean
    
    Select Case mt_MainConfig.NameFrame
        Case "SPA_Main"
            Dim lb_ITS          As Boolean
            Dim lb_superUser    As Boolean
            Dim lb_releaser     As Boolean
            Dim lb_COS          As Boolean
            Dim lb_requestor    As Boolean
            Dim lb_approver     As Boolean
            Dim lb_salesRepre   As Boolean
            Dim lb_SAP_ErrorReciever  As Boolean
            Dim lb_ValidToUpdater As Boolean
    
            Dim ll_SPM_Code     As Long
            If grd_main.SelectedCount > 0 Then
                ll_SPM_Code = CLng(grd_main.SelectedLine(0, "SPM_Code"))
            Else
                ll_SPM_Code = 0
            End If
            
            lb_ITS = isUserType(mo_userRghts.SPARights, SPA_ITS, ll_SPM_Code)
            lb_superUser = isUserType(mo_userRghts.SPARights, SPA_SuperUser, ll_SPM_Code)
            lb_releaser = isUserType(mo_userRghts.SPARights, SPA_Releaser, ll_SPM_Code)
            lb_COS = isUserType(mo_userRghts.SPARights, SPA_COS, ll_SPM_Code)
            lb_requestor = isUserType(mo_userRghts.SPARights, SPA_Requestor, ll_SPM_Code)
            lb_approver = isUserType(mo_userRghts.SPARights, SPA_Approver, ll_SPM_Code)
            lb_salesRepre = isUserType(mo_userRghts.SPARights, SPA_SalesRepresentative, ll_SPM_Code)
            lb_SAP_ErrorReciever = isUserType(mo_userRghts.SPARights, SAP_ErrorReciever, ll_SPM_Code)
            lb_ValidToUpdater = isUserType(mo_userRghts.SPARights, SPA_ValidToUpdater, ll_SPM_Code)
            
            
            tlb_main.Redraw = False
            tlb_main.ButtonVisible("A") = lb_ITS Or lb_superUser
            tlb_main.ButtonVisible("B") = lb_ITS Or lb_superUser
            tlb_main.ButtonVisible("C") = lb_ITS Or lb_superUser
            tlb_main.ButtonVisible("X") = lb_ITS Or lb_superUser
            tlb_main.ButtonVisible("v") = lb_ITS Or lb_superUser
            tlb_main.Redraw = True

        Case Else
    End Select

    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateMainToolbarCustom")
End Sub

Private Sub btn_applyFilters_Click()
On Error GoTo ErrHandler
    ' reload grid
    Call ReloadMainGrid
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("btn_applyFilters_Click")
End Sub

Private Sub btn_hideFilters_Click()
On Error GoTo ErrHandler
    ' hide filter frame
    frm_grdFilters.Visible = False
    mb_filtersVisible = False
    
    ' resize the grid to original size
    Call grd_main.Move(fra_MainFilter.Left + fra_MainFilter.Width + FRM_SPACE_HOR, tlb_main.Top + tlb_main.Height + FRM_SPACE_VER, grd_main.Width, grd_SPA_Detail.Top - frm_grdFilters.Top - 2 * FRM_SPACE_VER)
    Exit Sub
ErrHandler:
    Call ErrorMessage("btn_hideFilters_Click")
End Sub

Private Sub ShowFilters()
On Error GoTo ErrHandler
    ' show filter frame
    frm_grdFilters.Visible = True
    mb_filtersVisible = True
    
    ' resize the grid to original size
    Call grd_main.Move(fra_MainFilter.Left + fra_MainFilter.Width + FRM_SPACE_HOR, frm_grdFilters.Top + frm_grdFilters.Height + FRM_SPACE_VER, grd_main.Width, grd_SPA_Detail.Top - frm_grdFilters.Top - frm_grdFilters.Height - 2 * FRM_SPACE_VER)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("ShowFilters")
End Sub

Private Sub cal11_changeposition(y As Integer)

    cal11.Zorder
    cal11.Top = cal11.Top + y
End Sub

Private Sub cal11_datechangee()
On Error GoTo ErrHandler
    
Dim ll_MainConfig As Long
Dim ll_MainFrame As Long
    
    If Not mb_Initialized Then Exit Sub
    Call SetTreeDelayedMode(True)

    Exit Sub
ErrHandler:
    Call ErrorMessage("cal11_datechangee")
End Sub

Private Sub cal12_changeposition(y As Integer)

    cal12.Zorder
    cal12.Top = cal12.Top + y
End Sub

Private Sub cal12_datechangee()
On Error GoTo ErrHandler
    
Dim ll_MainConfig As Long
Dim ll_MainFrame As Long
    
    If Not mb_Initialized Then Exit Sub
    Call SetTreeDelayedMode(True)

    Exit Sub
ErrHandler:
    Call ErrorMessage("cal12_datechangee")
End Sub


Private Sub X_OnExit(ByVal as_configName As String)
On Error GoTo ErrHandler
    mt_MainConfig.ActiveDetailControl.Visible = False
    Set mt_MainConfig.ActiveDetailControl = Nothing
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".X_OnExit")
End Sub

Private Sub X_OnItemAdd(ByVal as_configName As String, ByVal av_Key As Variant, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    
    Dim lo_dataSrc As New Dictionary
    lo_dataSrc.CompareMode = TextCompare
    
    Call FillDataSrcArray(lo_dataSrc, as_SrzFields)

    Dim lo_Node As Node
    Dim ls_pathTmp As String
    Dim lv_pathData As Variant
    
    ' test if item is visible
    If Not IsItemInFilter(lo_dataSrc) Then
'        Call MsgBox(MsgText(7204, ms_Language_Code, "#Updated item cannot be displayed with current filter"))  ' bug 211
        Set lo_dataSrc = Nothing
        Exit Sub
    Else
        ' create path from selected line
        ls_pathTmp = Cbo_View.SelectedItem.GetData(2)
        If ls_pathTmp = "" Then
            Call AddLineToGrid(grd_main, lo_dataSrc)
            Call grd_Main_SelChange
            Set lo_dataSrc = Nothing
            Exit Sub
        End If
    
        ' try to find in treeView
        ' generate path from detail values
        lv_pathData = GetCurrentPathData(lo_dataSrc, ls_pathTmp)
        Set lo_Node = tvw_Main.SelectedItem
        
        Call FindInTreeView(tvw_Main, lv_pathData, True, False)
        If IsChildNode(lo_Node, tvw_Main.SelectedItem) Then
            If mt_MainConfig.GridDelayed Then
                If Not grd_main.Execute Then
                    Err.Raise ArmErr.CompFncFailed, "grd_Main.Execute", "Method Execute failed: " & grd_main.Requests(0)
                End If
                 mt_MainConfig.GridDelayed = False
                Call grd_main.SearchKey(True, av_Key)
            Else
                Call AddLineToGrid(grd_main, lo_dataSrc)
                Call grd_Main_SelChange
            End If
        Else
            MsgBox MsgText(7209, ms_Language_Code, "#Item not found under current filter criteria"), vbInformation, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
        End If
        Set tvw_Main.SelectedItem = lo_Node
    End If

    Set lo_dataSrc = Nothing
    Exit Sub
ErrHandler:
    Set lo_dataSrc = Nothing
    Call ErrorMessage(Extender.Name & ".X_OnItemAdd")
End Sub

Private Sub X_OnItemDelete(ByVal as_configName As String, ByVal av_Key As Variant, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    Dim lo_dataSrc As New Dictionary
    lo_dataSrc.CompareMode = TextCompare
    
    Call FillDataSrcArray(lo_dataSrc, as_SrzFields)
    
    If Not IsItemInFilter(lo_dataSrc) Then
    Call DeleteLineToGrid(grd_main, Array(GetGridKeyColumnFieldName(grd_main)), av_Key)
    Else
        Call UpdateLineToGrid(grd_main, lo_dataSrc, Array(GetGridKeyColumnFieldName(grd_main)))
    End If

    Set lo_dataSrc = Nothing
    Exit Sub
ErrHandler:
    Set lo_dataSrc = Nothing
    Call ErrorMessage(Extender.Name & ".X_OnItemDelete")
End Sub

Private Sub X_OnItemUpdate(ByVal as_configName As String, ByVal av_Key As Variant, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    
    Dim lo_dataSrc As New Dictionary
    lo_dataSrc.CompareMode = TextCompare
    
    Call FillDataSrcArray(lo_dataSrc, as_SrzFields)

    Dim lo_Node As Node
    Dim ls_pathTmp As String
    Dim lv_pathData As Variant
    
    ' test if item is visible
    If Not IsItemInFilter(lo_dataSrc) Then
        Call DeleteLineToGrid(grd_main, Array(GetGridKeyColumnFieldName(grd_main)), av_Key)
        Set lo_dataSrc = Nothing
        Exit Sub
    Else
        ' create path from selected line
        ls_pathTmp = Cbo_View.SelectedItem.GetData(2)
        
        If ls_pathTmp = "" Then
            Call UpdateLineToGrid(grd_main, lo_dataSrc, Array(GetGridKeyColumnFieldName(grd_main)))
            Exit Sub
        End If
    
        ' try to find in treeView
        ' generate path from detail values
        lv_pathData = GetCurrentPathData(lo_dataSrc, ls_pathTmp)
        
        Set lo_Node = tvw_Main.SelectedItem
        
        Call FindInTreeView(tvw_Main, lv_pathData, True, False)
        If IsChildNode(lo_Node, tvw_Main.SelectedItem) Then
            If mt_MainConfig.GridDelayed Then
                If Not grd_main.Execute Then
                    Err.Raise ArmErr.CompFncFailed, "grd_Main.Execute", "Method Execute failed: " & grd_main.Requests(0)
                End If
                 mt_MainConfig.GridDelayed = False
            End If
            Call UpdateLineToGrid(grd_main, lo_dataSrc, Array(GetGridKeyColumnFieldName(grd_main)))
        Else
            Call DeleteLineToGrid(grd_main, Array(GetGridKeyColumnFieldName(grd_main)), av_Key)
            Call grd_main.DeselectRow
        End If
        Set tvw_Main.SelectedItem = lo_Node
    End If

    Set lo_dataSrc = Nothing

    Exit Sub
ErrHandler:
    Set lo_dataSrc = Nothing
    Call ErrorMessage(Extender.Name & ".X_OnItemUpdate")
End Sub

Private Function IsChildNode(ByVal ao_parent As Node, ByRef ao_testNode As Node) As Boolean
On Error GoTo ErrHandler
    Dim lb_retVal As Boolean
    lb_retVal = (ao_testNode Is ao_parent)
    If lb_retVal Or ao_testNode.Parent Is Nothing Then
        IsChildNode = lb_retVal
        Exit Function
    End If
    lb_retVal = IsChildNode(ao_parent, ao_testNode.Parent)
    IsChildNode = lb_retVal
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".IsChildNode")
End Function

Private Sub X_OnItemNext(ByVal as_configName As String)
On Error GoTo ErrHandler
    
    If Not grd_main.NextItem Then
        Call MsgBox(MsgText(ErrMsg_M320, ms_Language_Code, "#No more next item"), vbInformation)
    End If

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".X_OnItemNext")
End Sub

Private Sub X_OnItemPrevious(ByVal as_configName As String)
On Error GoTo ErrHandler
    
    If Not grd_main.PreviousItem Then
        Call MsgBox(MsgText(ErrMsg_M310, ms_Language_Code, "#No more previous item"), vbInformation)
    End If

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".X_OnItemPrevious")
End Sub

Private Function GetGridKeyColumnFieldName(ByRef ao_grid As ArmGrid) As String
On Error GoTo ErrHandler
    Dim ll_Col As Long
    
    GetGridKeyColumnFieldName = ""
    For ll_Col = 0 To ao_grid.Cols - 1
        If ao_grid.Columns(ll_Col).Key Then
            ' we have key
            GetGridKeyColumnFieldName = ao_grid.Columns(ll_Col).FieldName
            Exit For
        End If
    Next

    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetGridKeyColumnFieldName")
End Function

Private Sub cbo_Date_Type_ComboItemSelected()
On Error GoTo ErrHandler

    Call LockScreen(True)
    Call SetTreeDelayedMode(True)
    Call LockScreen(False)

    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("cbo_Date_Type_ComboItemSelected")
End Sub

Private Sub chk_usedBySAP_Click()
On Error GoTo ErrHandler

    Call LockScreen(True)
    Call SetTreeDelayedMode(True)
    Call LockScreen(False)

    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("chk_usedBySAP_Click")
End Sub

Private Sub grd_SPA_Detail_RowLoaded(ByVal al_Row As Long)
On Error GoTo errhandler

    Dim ld_price As Double
    ld_price = grd_SPA_Detail.Data(al_Row, "Std_Price")
    
    If ld_price > 0 Then
        If ld_price <= grd_SPA_Detail.Data(al_Row, "SPA_Price") Then
            grd_SPA_Detail.CellColor(al_Row, "Std_Price") = vbYellow
            grd_SPA_Detail.CellColor(al_Row, "SPA_Price") = vbYellow
        End If
    End If

    Exit Sub
errhandler:
    Call ErrorMessage(Extender.Name & ".grd_SPA_Detail_RowLoaded")
End Sub

Private Sub mo_SPA_MAIN_OnExit()
On Error GoTo ErrHandler
    Call X_OnExit("SPA_Manin")
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SPA_MAIN_OnExit")
End Sub

Private Sub mo_SPA_MAIN_OnItemAdd(ByVal av_Key As Variant, ByVal as_SrzFields As String, ByVal as_SzProductGrid As String)
On Error GoTo ErrHandler
    Call X_OnItemAdd("SPA_Manin", av_Key, as_SrzFields)
    
    Call grd_SPA_Detail.ClearGrid
    grd_SPA_Detail.Visible = False
    Call grd_Main_SelChange

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SPA_MAIN_OnItemAdd")

End Sub

Private Sub mo_SPA_MAIN_OnItemDelete(ByVal av_Key As Variant, ByVal as_SrzFields As String, ByVal as_SzProductGrid As String)
On Error GoTo ErrHandler
    Call X_OnItemDelete("SPA_Manin", av_Key, as_SrzFields)
    
    Call grd_SPA_Detail.ClearGrid
    grd_SPA_Detail.Visible = False
    Call grd_Main_SelChange

    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SPA_MAIN_OnItemDelete")
End Sub

Private Sub mo_SPA_MAIN_OnItemNext()
On Error GoTo ErrHandler
    Call X_OnItemNext("SPA_Manin")
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SPA_MAIN_OnItemNext")
End Sub

Private Sub mo_SPA_MAIN_OnItemPrevious()
On Error GoTo ErrHandler
    Call X_OnItemPrevious("SPA_Manin")
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SPA_MAIN_OnItemPrevious")
End Sub

Private Sub mo_SPA_MAIN_OnItemUpdate(ByVal av_Key As Variant, ByVal as_SrzFields As String, ByVal as_SzProductGrid As String)
On Error GoTo ErrHandler
    Call X_OnItemUpdate("SPA_Manin", av_Key, as_SrzFields)
    
    Call grd_SPA_Detail.ClearGrid
    grd_SPA_Detail.Visible = False
    Call grd_Main_SelChange
    
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SPA_MAIN_OnItemUpdate")
End Sub

Private Sub mo_SPA_MAIN_OnPrint(ByVal av_Key As Variant, ByVal as_CT_Code As String)
On Error GoTo ErrHandler
    Call PrintSPA(av_Key(0), as_CT_Code, , False)
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SPA_MAIN_OnPrint")
End Sub

Private Sub mo_SPA_MAIN_OnEmail(ByVal av_Key As Variant, ByVal as_CT_Code As String, ByVal as_EMail As String)
On Error GoTo ErrHandler
    Call EmailSPA(av_Key(0), as_CT_Code, as_EMail)
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SPA_MAIN_OnPrint")
End Sub

Private Sub mo_SPA_MAIN_OnPrintPreview(ByVal av_Key As Variant, ByVal as_CT_Code As String)
On Error GoTo ErrHandler
    Call PrintSPA(av_Key(0), as_CT_Code, , True)
    Exit Sub
ErrHandler:
    Call ErrorMessage(Extender.Name & ".mo_SPA_MAIN_OnPrint")
End Sub

Private Sub opt_FilterDate_Click(Index As Integer)
On Error GoTo ErrHandler

    Call LockScreen(True)
    
    
    If Index = 1 Then
        cal11.Visible = True
        cal12.Visible = True
        cbo_Date_Type.Visible = (cbo_Date_Type.Count > 0)
    Else
        cal11.reinit_cal
        cal12.reinit_cal
        cal11.Visible = False
        cal12.Visible = False
        cbo_Date_Type.Visible = False
    End If
        
    Call SetTreeDelayedMode(True)
    Call LockScreen(False)

    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("opt_FilterDate_Click")
End Sub

Private Sub tbs_Status_Click()
On Error GoTo ErrHandler
    
    If Not mb_Initialized Then Exit Sub
    Call SetTreeDelayedMode(True)
    Exit Sub
ErrHandler:
    Call ErrorMessage("tbs_Status_Click")
End Sub

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK CONTROL EVENTS
' please DO NOT change anything in this part of code
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Sub tlb_main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    
    If Not tlb_main.Enabled Then Exit Sub
    
    Call LockScreen(True)
    
    If Not tlb_Main_CustomAction(as_Role, as_Language) Then
        Select Case as_Role
            Case "A"
                ' Want to Add
                Call InitDetailControl
                ' load detail
                If Not mt_MainConfig.ActiveDetailControl Is Nothing Then
                    Call mt_MainConfig.ActiveDetailControl.Run(SPA_Mode.emAdd, Array(""))
                    If Not mt_MainConfig.ActiveDetailControl Is Nothing Then mt_MainConfig.ActiveDetailControl.Visible = True
                End If
            Case "B"
                If grd_main.SelectedCount > 0 Then
                    ' Want to Update
                    Call InitDetailControl
                    ' load detail
                    If Not mt_MainConfig.ActiveDetailControl Is Nothing Then
                        Call mt_MainConfig.ActiveDetailControl.Run(SPA_Mode.emUpdate, grd_main.CurrentKey)
                        If Not mt_MainConfig.ActiveDetailControl Is Nothing Then mt_MainConfig.ActiveDetailControl.Visible = True
                    End If
                Else
                    MsgBox MsgText(WarMsgSelectRow, ms_Language_Code, "#Please select a row."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
                End If
            Case "C"
                If grd_main.SelectedCount > 0 Then
                    ' Want to delete
                    Call InitDetailControl
                    ' load detail
                    If Not mt_MainConfig.ActiveDetailControl Is Nothing Then
                        Call mt_MainConfig.ActiveDetailControl.Run(SPA_Mode.emDelete, grd_main.CurrentKey)
                        If Not mt_MainConfig.ActiveDetailControl Is Nothing Then mt_MainConfig.ActiveDetailControl.Visible = True
                    End If
                Else
                    MsgBox MsgText(WarMsgSelectRow, ms_Language_Code, "#Please select a row."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
                End If
            Case "D" 'print
                If grd_main.SelectedCount > 0 Then
                    If grd_main.SelectedLine(0, "SPA_ApprovalStatus") = eSPA_ApprovalStatus.SPAS_Approved Or _
                        grd_main.SelectedLine(0, "SPA_ApprovalStatus") = eSPA_ApprovalStatus.SPAS_Released Then
                        Call PrintSPA(grd_main.CurrentKey(0), grd_main.SelectedLine(0, "CT_Code"), , False)
                    Else
                        Call PrintSPA(grd_main.CurrentKey(0), grd_main.SelectedLine(0, "CT_Code"), , True)
'                        MsgBox MsgText(ErrMsg_M130, ms_Language_Code, "#Cannot Print."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
                    End If
                End If
            Case "u"    ' email
                If grd_main.SelectedCount > 0 Then
                    If grd_main.SelectedLine(0, "SPA_ApprovalStatus") = eSPA_ApprovalStatus.SPAS_Approved Or _
                        grd_main.SelectedLine(0, "SPA_ApprovalStatus") = eSPA_ApprovalStatus.SPAS_Released Then
                        Call EmailSPA(grd_main.CurrentKey(0), grd_main.SelectedLine(0, "CT_Code"), grd_main.SelectedLine(0, "Email"))
                    Else
                        MsgBox MsgText(ErrMsg_M130, ms_Language_Code, "#Cannot email."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
                    End If
                End If
            Case "L"
            ' Want to reload treeview and refresh the grid
                Call ReloadMainGrid
            Case "F"
                ' Want to reload grid according to treeview selection
                Call ReloadMainTreeview
            Case "N"
                ' search on grid
                Call ShowFilters
            Case "Q"
                Call cbo_View_ComboItemSelected
            Case "T"
'                Call ScanControls
                RaiseEvent quit
            Case "v"
                If grd_main.SelectedCount > 0 Then
                    ' Want to Update
                    Call InitDetailControl
                    ' load detail
                    If Not mt_MainConfig.ActiveDetailControl Is Nothing Then
                        Call mt_MainConfig.ActiveDetailControl.Run(SPA_Mode.emUpdateStauts, grd_main.CurrentKey, SPAS_Submited)
                        If Not mt_MainConfig.ActiveDetailControl Is Nothing Then mt_MainConfig.ActiveDetailControl.Visible = True
                    End If
                Else
                    MsgBox MsgText(WarMsgSelectRow, ms_Language_Code, "#Please select a row."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
                End If
            Case "X"
                If grd_main.SelectedCount > 0 Then
                    ' Want to Update
                    Call InitDetailControl
                    ' load detail
                    If Not mt_MainConfig.ActiveDetailControl Is Nothing Then
                        Call mt_MainConfig.ActiveDetailControl.Run(SPA_Mode.emCopy, grd_main.CurrentKey)
                        If Not mt_MainConfig.ActiveDetailControl Is Nothing Then mt_MainConfig.ActiveDetailControl.Visible = True
                    End If
                Else
                    MsgBox MsgText(WarMsgSelectRow, ms_Language_Code, "#Please select a row."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
                End If

            Case Else
                Err.Raise ArmErr.InvalidArgument, "tlb_Main_action", "Unknown main toolbar role as_Role=" & as_Role
        End Select
    End If
    Call LockScreen(False)
    
    Exit Sub
ErrHandler:
    Call UpdateError(True)
    Call LockScreen(False)

    Select Case Err.Number
    Case 202
        MsgBox MsgText(666, ms_Language_Code, "#The item you have added/updated couldn't be displayed with the current criteria set."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    Case ArmErr.SQLBadRowExpectedCount
        MsgBox MsgText(666, ms_Language_Code, "#The record you try to open has been deleted by an other user. Please refresh the grid."), vbInformation, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    Case ArmErr.SQLBadRowAffectedCount
        MsgBox MsgText(666, ms_Language_Code, "#This record has been, modified by an other.Please exit from this screen and refresh the grid."), vbInformation, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    Case Else
        Call LogMessage("tlb_list_action")
        ' user interface can be inconsistent, better to close application
        Call UpdateError(False)
        Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & Err.Source & vbCrLf & "Description: " & Err.Description, , App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
        End
    End Select
End Sub

Private Sub cbo_View_ComboItemSelected()
On Error GoTo ErrHandler

    Call LockScreen(True)
    
     If Not Cbo_View.SelectedItem Is Nothing Then
        
        Call LoadTreeView(tvw_Main, GetTreeViewInfo(mt_MainConfig.mTreeViewInfos, mt_MainConfig.ViewCode, Cbo_View.SelectedItem.Key))
        If tvw_Main.Count > 0 Then
            Set tvw_Main.SelectedItem = tvw_Main.Nodes(1)
            Call tvw_Main_NodeClick(tvw_Main.SelectedItem)
        Else
            Call tvw_Main_NodeClick(Nothing)
        End If
        Call SetTreeDelayedMode(False)
    End If
    
CleanUp:
    Call LockScreen(False)
    Exit Sub
    
ErrHandler:
    Call LogMessage("cbo_Views_ComboItemSelected")
    Call LockScreen(False)
    MsgBox MsgText(666, ms_Language_Code, "#Unable to load the combo " & " type of view."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
End Sub

Private Sub pic_filtersReset_Click()
On Error GoTo ErrHandler
    Call LockScreen(True)
    
    ' reset filters
    
    Select Case mt_MainConfig.NameFrame
        Case "SPA_Main"
            Set tbs_Status.SelectedItem = tbs_Status.Tabs(1)
            opt_FilterDate(0).Value = True
            Set tbs_ProjectType.SelectedItem = tbs_ProjectType.Tabs(1)
            Call Cbo_View.SearchItem("X", "TV_Default", 0)
            Call cbo_Date_Type.SearchItem("1", "cbo_def_index", 0)
        Case Else
            Debug.Assert (False)
    End Select
    
    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("pic_filtersReset_Click")
End Sub

Private Sub cmd_TVReLoad_Click()
On Error GoTo ErrHandler
    
    Call cbo_View_ComboItemSelected
    Exit Sub
ErrHandler:
    Call ErrorMessage("cmd_TVReLoad_Click")
End Sub

Private Sub tvw_Main_NodeClick(ByVal Node As MSComctlLib.Node)
On Error GoTo ErrHandler
    
    If mb_InternalInit Then Exit Sub
    
    Call LockScreen(True)
    
    Dim lv_Requests As Variant, lb_DelayedLoad As Boolean
    
    If tvw_Main.Checkboxes = True Then
        lv_Requests = ApplyTVFilters(tvw_Main.CheckedNodesRequests)
    Else
    lv_Requests = ApplyTVFilters(tvw_Main.SelectedNodeRequest)
    End If
    
    If Not (Node Is Nothing) Then
        If (tvw_Main.NodeInfo(Node).ml_Level = tvw_Main.Levels - 1) Then
            mt_MainConfig.CurrentTvwSelMethod = eTvwSelMethod.etmNode
        Else
            mt_MainConfig.CurrentTvwSelMethod = eTvwSelMethod.etmBranch
        End If
    Else
        mt_MainConfig.CurrentTvwSelMethod = etmNone
    End If
    
    Select Case mt_MainConfig.GridDelayMethod
    Case egmDelayedAlways
        lb_DelayedLoad = True
    Case egmDelayedExceptLastLevel
        If Node Is Nothing Then
            lb_DelayedLoad = True
        Else
            lb_DelayedLoad = (tvw_Main.NodeInfo(Node).ml_Level < tvw_Main.Levels - 1)
        End If
    Case egmLoadAlways
        lb_DelayedLoad = False
    Case Else
        lb_DelayedLoad = True
    End Select
    
    If grd_main.Cols = 0 Then
        
        If Not grd_main.SetColumns(mt_MainConfig.MainGridColumns) Then
            Err.Raise ArmErr.CompFncFailed, "grd_Main", "Method SetColumns failed."
        End If
        
        If Not grd_SPA_Detail.SetColumns(mt_MainConfig.SubGridColumns) Then
            Err.Raise ArmErr.CompFncFailed, "grd_SPA_Detail", "Method SetColumns failed."
        End If

        Call LoadLabels(mo_Db, fra_MainItem, SCREEN_NAME, ms_Language_Code)
    End If
    
    mt_MainConfig.GridDelayed = lb_DelayedLoad
    
    If Not grd_main.Load(ApplyGridFilters(lv_Requests, Not mb_filtersVisible), False, , , lb_DelayedLoad) Then
        Err.Raise ArmErr.CompFncFailed, "grd_Main", "Method Load failed: " & lv_Requests(0)
    End If
    
    Call grd_SPA_Detail.ClearGrid
    grd_SPA_Detail.Visible = False
    
    ' update requests for cbo of towns and cbo of projects
    Dim ls_Townkey As String
    Dim ls_Projectkey As String
    Dim ls_ProjectDesc As String
    
    ls_Townkey = GetComboKey(cbo_CCU_Town)
    ls_Projectkey = GetComboKey(cbo_Project)
    ls_ProjectDesc = cbo_Project.Text
    
    Call cbo_CCU_Town.Clear
    Call cbo_Project.Clear
    cbo_CCU_Town.Request = DeleteGridFilterPlaceholders(Replace(lv_Requests(0), "SPA_Main_lst", "SPA_Main_Towns_cbo", , , vbTextCompare))
    cbo_Project.Request = DeleteGridFilterPlaceholders(Replace(lv_Requests(0), "SPA_Main_lst", "SPA_Main_Projects_cbo", , , vbTextCompare))
    
    If ls_Townkey <> "" Then
        Call cbo_CCU_Town.AddItem(Array(ls_Townkey, ls_Townkey), True)
    End If
    
    If ls_Projectkey <> "" Then
        Call cbo_Project.AddItem(Array(ls_Projectkey, ls_ProjectDesc), True)
    End If
    
    Call UpdateMainToolbarCustom
    Call LockScreen(False)
    Exit Sub

ErrHandler:
    Call LogMessage("tvw_Main_NodeClick")
    Call LockScreen(False)
    MsgBox MsgText(666, ms_Language_Code, "#There is a problem while loading data."), vbInformation + vbOKOnly, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
End Sub

Private Sub tbs_ProjectType_Click()
On Error GoTo ErrHandler
    
    Call SetTreeDelayedMode(True)
    Exit Sub
ErrHandler:
    Call ErrorMessage("tbs_ProjectType_Click")
End Sub


Private Sub grd_Main_ItemSelected()
On Error GoTo ErrHandler
    
    Dim lb_Locked As Boolean
    
    If grd_main.SelectedCount < 1 Then Exit Sub
    
    Call LockScreen(True)
    lb_Locked = True
    
    If grd_Main_CustomAction(eControlAction.caDoubleClick) Then
        Call LockScreen(False)
        lb_Locked = False
        Exit Sub
    End If
    
'    Call Item_ViewInit(ll_DetailIndex, grd_Main(Index).CurrentKey)
    Call LockScreen(False)
    lb_Locked = False
    Exit Sub
ErrHandler:
    If lb_Locked Then Call LockScreen(False)
    Select Case Err.Number
        Case ArmErr.SQLBadRowExpectedCount
            MsgBox MsgText(666, ms_Language_Code, "#The record you try to open has been deleted by an other user. Please refresh the grid."), vbInformation, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
        Case Else
            Call LogMessage("grd_Main_ItemSelected")
            MsgBox MsgText(666, ms_Language_Code, "#There is a problem while doing this action. Please double check your entry."), vbInformation, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    End Select
End Sub

Private Sub grd_Main_SelChange()
On Error GoTo ErrHandler
    Dim ls_req As String
    If mb_InternalInit Then Exit Sub
    
    Call LockScreen(True)
    If grd_main.SelectedCount > 0 Then
        ' LOAD ITEMS INTO BOTTOM GRID
        ls_req = Replace(ReplaceCommonPlaceholders(REQ_SELECT_DETAIL_ITEMS_GRID), "$SPA_Id$", grd_main.SelectedKey(0)(0), , , vbTextCompare)
        If Not grd_SPA_Detail.Load(ls_req, False, , , True) Then
            Err.Raise ArmErr.CompFncFailed, "grd_SPA_Detail().Load", "Load grid failed: " & ls_req
        End If
        grd_SPA_Detail.Visible = True
    Else
        grd_SPA_Detail.Visible = False
    End If
    
    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call LogMessage("grd_Main_SelChange")
    MsgBox MsgText(666, ms_Language_Code, "#There is a problem while doing this action. Please double check your entry."), vbInformation, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
End Sub

Private Sub grd_Main_RowColChange()
On Error GoTo ErrHandler
    mt_MainConfig.GridDelayed = False
    Call UpdateMainToolbarCustom
    Exit Sub
ErrHandler:
    Call ErrorMessage("grd_Main_RowColChange")
End Sub


'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK METHODS
' please DO NOT change anything in this part of code
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Function Load_A_COM() As Boolean

Dim ll_Index As Long
Dim lo_Control As Object

On Error GoTo ErrHandler
    
    Load_A_COM = False
    
    If Initialized Then Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    If mo_Db Is Nothing Then Call Err.Raise(ArmErr.PropertyNotSet, "", "mo_Db")
    If Len(ms_Language_Code) < 1 Then Call Err.Raise(ArmErr.PropertyNotSet, "", "ms_Language_Code")
    
    mb_filtersVisible = False
    mb_InternalInit = False
    ms_DecimalSeparator = Format(0, ".")
    Dim sBuffer As String
    Dim nBufferLen As Long
    nBufferLen = 255
    sBuffer = String$(nBufferLen, vbNullChar)
    nBufferLen = GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND, sBuffer, nBufferLen)
    If nBufferLen > 0 Then
        ms_ThousandSeparator = Left$(sBuffer, nBufferLen - 1)
    End If
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "ARMPICKER"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "TOOLBARCONTROL"
            lo_Control.Language = ms_Language_Code
            lo_Control.HideTips = True
            lo_Control.Load_A_COM
        Case "ARMGRID"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "ARMTREEVIEW"
            Set lo_Control.ArmDb = mo_Db
            lo_Control.Language = ms_Language_Code
            Call lo_Control.Load_A_COM
        Case "ARMCHECKVIEW"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_COM
        Case "A_CALOCX"
            lo_Control.Language = ms_Language_Code
            Call lo_Control.reinit_cal
        End Select
    Next
    
    Set mo_FSO = CreateObject("Scripting.FileSystemObject")
    
    If Init_control Then
        Load_A_COM = True
        mb_Initialized = True
        Call InitMainFrame
    Else
        mb_Initialized = True
        Call InitMainFrame
    End If
    
    Exit Function
ErrHandler:
    Call ErrorMessage("Load_A_COM")
End Function

Public Function Unload_A_COM() As Boolean
    
On Error GoTo ErrHandler
    
    Dim lo_Control As Object
    Dim ll_Index As Long
    
    If mc_ScreenLabels <> 0 Then mo_Db.Close (mc_ScreenLabels)
    mc_ScreenLabels = 0
    If mc_Toolbars <> 0 Then mo_Db.Close (mc_Toolbars)
    mc_Toolbars = 0
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX", "TOOLBARCONTROL", "ARMGRID", "ARMTREEVIEW", "ARMCHECKVIEW", "ARMPICKER", "SRM_TASK"
            Call lo_Control.Unload_A_COM
        End Select
    Next
        
'    Debug.Assert (mo_Db.CursorCount = 0)
    
    Set mo_Db = Nothing
    Set mo_FSO = Nothing
    mb_Initialized = False
    Unload_A_COM = True
    Exit Function
ErrHandler:
    Unload_A_COM = False
    Call ErrorMessage("Unload_A_Com")
End Function

Public Sub Resize()
On Error GoTo ErrHandler

    If Not Resize_Custom Then
        Call ResizeMain
    End If
    Exit Sub
ErrHandler:
    Call ErrorMessage("Resize")
End Sub

Private Sub ResizeMain()
On Error GoTo ErrHandler


    If Width < 0 Or Height < 0 Then Exit Sub
    
    Call fra_MainItem.Move(0, 0, Width, Height - 2 * FRM_SPACE_VER)
    Call pic_filtersReset.Move(0, 90)
    Call tlb_main.Move(fra_MainFilter.Left + fra_MainFilter.Width + FRM_SPACE_HOR, 2 * FRM_SPACE_VER)
    Call grd_main.Move(fra_MainFilter.Left + fra_MainFilter.Width + FRM_SPACE_HOR, tlb_main.Top + tlb_main.Height + FRM_SPACE_VER, grd_main.Width, grd_SPA_Detail.Top - frm_grdFilters.Top - 2 * FRM_SPACE_VER)
    Call grd_SPA_Detail.Move(fra_MainFilter.Left + fra_MainFilter.Width + FRM_SPACE_HOR)
    
    If mt_MainConfig.HasTreeview Then
        If fra_MainItem.Height - (Cbo_View.Top + Cbo_View.Height + 4 * FRM_SPACE_VER) > 0 Then
            tvw_Main.Height = fra_MainItem.Height - (Cbo_View.Top + Cbo_View.Height + 4 * FRM_SPACE_VER)
        End If
        
        If tbs_ProjectType.Tabs.Count > 1 Then
            If fra_MainItem.Height - (Cbo_View.Top + Cbo_View.Height + 4 * FRM_SPACE_VER + tbs_ProjectType.Height) > 0 Then
                tvw_Main.Height = fra_MainItem.Height - (Cbo_View.Top + Cbo_View.Height + 1 * FRM_SPACE_VER + tbs_ProjectType.Height)
            End If
            Call tbs_ProjectType.Move(tvw_Main.Left, tvw_Main.Top + tvw_Main.Height, tvw_Main.Width)
            tbs_ProjectType.Visible = True
        Else
            tbs_ProjectType.Visible = False
        End If
        Call cmd_TVReLoad.Move(tvw_Main.Left, tvw_Main.Top)
    End If
    
    If fra_MainItem.Height - grd_main.Top - 3 * FRM_SPACE_VER > 0 Then
        grd_SPA_Detail.Height = fra_MainItem.Height - grd_SPA_Detail.Top - FRM_SPACE_VER
    End If
    If fra_MainItem.Width - grd_main.Left - FRM_SPACE_HOR > 0 Then
        grd_main.Width = fra_MainItem.Width - grd_main.Left - FRM_SPACE_HOR
        grd_SPA_Detail.Width = grd_main.Width
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler("ResizeMain")
End Sub
Public Function Init_control() As Boolean
Dim ll_Index As Long

On Error GoTo ErrHandler

    Init_control = False
    mb_InternalInit = True
    Call Load_ConfigInfo
    
    ' init controls
    Call ChangeCharset(UserControl.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))
    Call LoadLabels(mo_Db, UserControl.Controls, SCREEN_NAME, ms_Language_Code)
    
    ms_UserName = LoadUserInfo(mo_Db, ml_U_Code)
    
    Call Component_SetUp(cbo_CCU_Town, "CCU_town")
    Call Component_SetUp(cbo_Project, "SP_CapKey")
    Call Component_SetUp(txt_Comment, "SPA_Comment" & SEP & "Text")
    Call Component_SetUp(txt_CustName, "CCU_Desc" & SEP & "Text")
    Call Component_SetUp(txt_SPAID, "SPA_ID" & SEP & "Text")
    Call Component_SetUp(txt_itemNb, "BI_SAP_Code" & SEP & "Text")

    'SPA module = 2422
    ms_ToolbarRequest = "exec A_ToolbarDef_sel NULL,2422,NULL,NULL"
    
    cal11.opening_toward_top = 1
    cal12.opening_toward_top = 1
    
    mb_InternalInit = False
    
    If Not InitUserRights(ml_U_Code) Then
        Exit Function
    End If
    
    Init_control = True
    Exit Function
ErrHandler:
    mb_InternalInit = False
    Call ErrorMessage("Init_control")
End Function

Private Sub InitDetailControl()
On Error GoTo ErrHandler
    
    Select Case mt_MainConfig.NameFrame
        Case "SPA_Main"
            If mo_SPA_MAIN Is Nothing Then
                Set mo_SPA_MAIN = UserControl.Controls.Add(C_ProgID & ".SPA_Main", "mo_SPA_MAIN", fra_MainItem)
                mo_SPA_MAIN.Visible = False
                Call mo_SPA_MAIN.Move(0, 0, fra_MainItem.Width, fra_MainItem.Height)
                
                mo_SPA_MAIN.Language_Code = ms_Language_Code
                mo_SPA_MAIN.U_Code = ml_U_Code
                mo_SPA_MAIN.LoginName = ms_LoginName
                Set mo_SPA_MAIN.DB = mo_Db
                
                Call mo_SPA_MAIN.Load_A_COM
                If Not mo_SPA_MAIN.Initialized Then
                    Call Err.Raise(ArmErr.CompFncFailed, "mo_SPA_MAIN.Initialized", "SPA_MAIN cannot was not initialised")
                End If
                mo_SPA_MAIN.Zorder
            End If
            Set mt_MainConfig.ActiveDetailControl = mo_SPA_MAIN
        Case Else
    End Select
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".InitDetailControl")
End Sub

Private Sub InitMainFrame()
On Error GoTo ErrHandler

Const VIEW_REQUEST = "exec TreeView_View_t_lst $ViewCode$,$Language_Code$"
Const CBO_REQUEST = "exec CapTV_date_cbo $ViewCode$,$Language_Code$"


Dim ls_Request As String, ls_ToolbarInfo As String

    If mt_MainConfig.Initialized Then Exit Sub
    
    Call ResizeMain
    
    Call LoadToolbar(tlb_main, mt_MainConfig.ToolbarID)
    Call tlb_main.DisplayFace(mt_MainConfig.ToolbarFace)
    
    ' update toolba according to use rights
    Call UpdateMainToolbar(mo_userRghts)
    
    If mt_MainConfig.HasTreeview Then
        ls_Request = ReplacePlaceHolder(VIEW_REQUEST, "$ViewCode$", SQLStr(mt_MainConfig.ViewCode))
        ls_Request = ReplacePlaceHolder(ls_Request, "$Language_Code$", SQLStr(ms_Language_Code))
        
        Cbo_View.Request = ls_Request
        Call Cbo_View.Load
        
        If Cbo_View.Count = 0 Then
            Cbo_View.Visible = False
        Else
            Dim ll_Idx As Long, ll_Count As Long
            ll_Count = Cbo_View.Count - 1
            ReDim mt_MainConfig.mTreeViewInfos(ll_Count)
            For ll_Idx = 0 To ll_Count
                mt_MainConfig.mTreeViewInfos(ll_Idx).Loaded = False
                mt_MainConfig.mTreeViewInfos(ll_Idx).TreeViewCode = Cbo_View.ComboItems(ll_Idx + 1).Key
            Next
            
            Call Cbo_View.SearchItem("X", "TV_Default", 0)
        End If

        ls_Request = ReplacePlaceHolder(CBO_REQUEST, "$ViewCode$", SQLStr(mt_MainConfig.ViewCode & "DATE"))
        ls_Request = ReplacePlaceHolder(ls_Request, "$Language_Code$", SQLStr(ms_Language_Code))
        
        cbo_Date_Type.Request = ls_Request
        Call cbo_Date_Type.Load
        
        If cbo_Date_Type.Count = 0 Then
            cbo_Date_Type.Visible = False
        Else
            Call cbo_Date_Type.SearchItem("1", "cbo_def_index", 0)
        End If
    
        cbo_CCU_Town.FirstBlankItem = True
        cbo_Project.FirstBlankItem = True
        
        cbo_CCU_Town.Request = ""
        cbo_Project.Request = ""
        
        txt_Comment.Text = ""
        txt_SPAID.Text = ""
        txt_CustName.Text = ""
        txt_itemNb.Text = ""
    
    Else
        Call ReloadMainFilterGrid
    End If
    mt_MainConfig.Initialized = True
    Exit Sub
ErrHandler:
    Call ErrorMessage("InitMainFrame")
End Sub

Private Sub InitFrameControls(ByRef av_InitControls As Variant)
On Error GoTo ErrHandler

Dim lo_Control As Control
Dim ll_Index As Long
Dim ls_Request As String

    If Not IsArray(av_InitControls) Then Exit Sub
    mb_InternalInit = True
    For ll_Index = 0 To UBound(av_InitControls)
        Set lo_Control = av_InitControls(ll_Index)(0)
        
        lo_Control.Tag = av_InitControls(ll_Index)(1)
        lo_Control.Visible = av_InitControls(ll_Index)(2)
        Select Case UCase(TypeName(lo_Control))
            Case "ARMCOMBOBOX"
                If UBound(av_InitControls(ll_Index)) >= 3 Then
                    ls_Request = av_InitControls(ll_Index)(3)
                    ls_Request = ReplaceCommonPlaceholders(ls_Request)
                    lo_Control.Request = ls_Request
                End If
            Case "TEXTBOX", "ARMPICKER"
                If UBound(av_InitControls(ll_Index)) >= 4 Then
                    lo_Control.MaxLength = av_InitControls(ll_Index)(4)
                End If
            Case "A_CALOCX"
            Case "LABEL", "CHECKBOX"
                lo_Control.Caption = "#" & lo_Control.Tag
        End Select
    Next
    mb_InternalInit = False
    Exit Sub
ErrHandler:
    mb_InternalInit = False
    Call ErrorHandler("InitFrameControls")
End Sub

Private Sub InitMandatoryLabels(ByRef av_ListFieldsMandatory As Variant)
On Error GoTo ErrHandler

Dim ll_Index As Long
Dim lo_Label As Label

    For ll_Index = 0 To UBound(av_ListFieldsMandatory)
        If av_ListFieldsMandatory(ll_Index)(1) >= 0 Then
            Set lo_Label = lbl_Label(av_ListFieldsMandatory(ll_Index)(1))
            lo_Label.FontBold = True
        End If
    Next
    Exit Sub
ErrHandler:
    Call ErrorHandler("InitMandatoryLabels")
End Sub

Private Function GetSelectedRootNode(ByRef ao_Tree As ArmTreeView) As MSComctlLib.Node
On Error GoTo ErrHandler

Dim lo_Node  As Object

    Set GetSelectedRootNode = Nothing
    Set lo_Node = ao_Tree.SelectedItem
    If Not (lo_Node Is Nothing) Then
        While Not (lo_Node.Parent Is Nothing)
            Set lo_Node = lo_Node.Parent
        Wend
    End If
    Set GetSelectedRootNode = lo_Node
    Exit Function
ErrHandler:
    Call ErrorHandler("GetSelectedRootNode")
End Function

Private Sub SetMode(ByVal ae_Mode As eMode)
On Error GoTo ErrHandler

    Exit Sub
ErrHandler:
    Call ErrorHandler("SetMode")
End Sub

Private Sub ResetFrameControls(ByRef ao_Frame As Frame)
On Error GoTo ErrHandler

Dim lo_Control As Control

    mb_InternalInit = True
    For Each lo_Control In UserControl.Controls
    
        If HasContainer(lo_Control, ao_Frame) Then
            If StrComp(lo_Control.Name, "chk_Repositioning", vbTextCompare) <> 0 Then
                Select Case UCase(TypeName(lo_Control))
                    Case "ARMCOMBOBOX"
                        Call lo_Control.Clear
                        lo_Control.Tag = ""
                        lo_Control.Request = ""
                        lo_Control.Visible = False
                    Case "ARMPICKER"
                        Call lo_Control.Clear
                        lo_Control.Tag = ""
                        lo_Control.Visible = False
                    Case "CHECKBOX"
                        lo_Control.Value = Unchecked
                        lo_Control.Tag = ""
                        lo_Control.Caption = ""
                        lo_Control.Visible = False
                    Case "TEXTBOX"
                        lo_Control.Tag = ""
                        lo_Control.Text = ""
                        lo_Control.Visible = False
                    Case "A_CALOCX"
                        Call lo_Control.reinit_cal
                        lo_Control.Tag = ""
                        lo_Control.Visible = False
                    Case "LABEL"
                        lo_Control.Tag = ""
                        lo_Control.Caption = ""
                        lo_Control.FontBold = False
                        lo_Control.Visible = False
                End Select
            End If
        End If
    Next
    mb_InternalInit = False
    Exit Sub
ErrHandler:
    mb_InternalInit = False
    Call ErrorHandler("ResetFrameControls")
End Sub

Private Sub LoadToolbar(ByRef ao_Toolbar As Object, ByVal al_Id As Long)
On Error GoTo ErrHandler

Dim ls_Request As String
Dim ls_ToolbarInfo As String

    ' no toolbar definition ID, do not load anything
    If (al_Id = 0) Or (ms_ToolbarRequest = "") Then Exit Sub
    'load all definition strings only once and keep it in cursor
    If mc_Toolbars = 0 Then
        ls_Request = ReplacePlaceHolder(ms_ToolbarRequest, "$Module$", SQLStr(SCREEN_NAME))
        mc_Toolbars = OpenSQLSafe(mo_Db, ls_Request)
    End If

    If mo_Db.Find(mc_Toolbars, "Id", al_Id) < 0 Then
        Err.Raise ArmErr.InvalidValue, ao_Toolbar.Name, "Toolbar not found in toolbars_definitions ID:" & al_Id
    End If
    
    ls_ToolbarInfo = mo_Db.GetFields(mc_Toolbars, "info")
    If Not ao_Toolbar.SetToolbarInfoStringParameters(ls_ToolbarInfo, Left(ls_ToolbarInfo, 3)) Then
        Err.Raise ArmErr.InvalidValue, ao_Toolbar.Name, "SetToolbarInfoStringParameters failed for toolbar ID:" & al_Id
    End If
    Call ao_Toolbar.DisplayFace("0")
    Exit Sub
ErrHandler:
    Call ErrorHandler("LoadToolbar")
End Sub

'to check if our current position in treeview will allow us to display added/updated item in grid
Private Function IsItemSelectedInTree(ByVal al_DetailIndex As Long, ByRef ao_Tree As ArmTreeView, ByVal av_PathData As Variant) As Boolean
On Error GoTo ErrHandler
    
Dim ll_SelLevel As Long, ll_IdxLvl As Long
Dim lo_Node As Object
Dim lb_CheckDone As Boolean


    IsItemSelectedInTree = IsItemSelectedInTreeCustom(al_DetailIndex, ao_Tree, av_PathData, lb_CheckDone)
    If lb_CheckDone Then Exit Function
    
    IsItemSelectedInTree = False
    
    Set lo_Node = ao_Tree.SelectedItem
    If lo_Node Is Nothing Then Exit Function
    If Not IsArray(av_PathData) Then Exit Function
    
    ll_SelLevel = lo_Node.Tag.ml_Level
    
    If ll_SelLevel > UBound(av_PathData) Then
        IsItemSelectedInTree = False
        Exit Function
    End If
    
    For ll_IdxLvl = ll_SelLevel To 0 Step -1
        If lo_Node Is Nothing Then Exit Function
        If Not IsArray(av_PathData(ll_IdxLvl)) Then
            Err.Raise ArmErr.InvalidValue, "av_PathData(ll_IdxLvl)", "Path data element is not an array: " & ll_IdxLvl
        End If
        If StrComp(lo_Node.Tag.IDValue, av_PathData(ll_IdxLvl)(0), vbTextCompare) <> 0 Then
            Exit Function
        End If
        Set lo_Node = lo_Node.Parent
    Next
    IsItemSelectedInTree = True
    Exit Function
ErrHandler:
    Call ErrorHandler("IsItemSelectedInTree")
End Function

' Return true if have created the node
' TODO : Manage the third parameter...
Private Function FindInTreeView(ByRef ao_Tree As ArmTreeView, ByVal av_PathData As Variant, ByVal ab_AutoCreate As Boolean, ByVal ab_Expand As Boolean) As Node
On Error GoTo ErrHandler

Dim lb_Internal As Boolean
Dim lo_Node As Object
Dim ll_LvlIdx As Long, ll_DataIdx As Long
Dim ls_Key As String, ls_Desc As String
    
    Set FindInTreeView = Nothing
    lb_Internal = mb_InternalInit
    mb_InternalInit = True
    Set lo_Node = Nothing
    For ll_LvlIdx = 0 To UBound(av_PathData)
        If Not IsArray(av_PathData(ll_LvlIdx)) Then
            Err.Raise ArmErr.InvalidValue, "av_PathData(ll_LvlIdx)", "Path data element is not an array"
        End If
        
        If UBound(av_PathData(ll_LvlIdx)) = 1 Then
            ls_Key = av_PathData(ll_LvlIdx)(0)
            ls_Desc = av_PathData(ll_LvlIdx)(1)
        ElseIf UBound(av_PathData(ll_LvlIdx)) > 1 Then
            ls_Key = av_PathData(ll_LvlIdx)(0)
            ls_Desc = av_PathData(ll_LvlIdx)(2)
        Else
            Err.Raise ArmErr.InvalidValue, "av_PathData(ll_LvlIdx)", "Invalid count of path data elements"
        End If
        
        If ao_Tree.Find(ls_Key, 0, lo_Node, ll_LvlIdx) Then
            Set lo_Node = ao_Tree.SelectedItem
        Else
            If ab_AutoCreate Then
                'TODO add additional data from detail tree into main tree data
                Set lo_Node = ao_Tree.AddNode(lo_Node, ls_Key, ls_Desc, 1, 2, LoadTypeChildsDemand)
                If lo_Node Is Nothing Then
                    Err.Raise ArmErr.CompFncFailed, "ao_Tree.AddNode", "Function failed to create node"
                End If
                For ll_DataIdx = 1 To UBound(av_PathData(ll_LvlIdx))
                    Call lo_Node.Tag.SetData(ll_DataIdx, av_PathData(ll_LvlIdx)(ll_DataIdx))
                Next
                lo_Node.Selected = True
            Else
                GoTo CleanUp
            End If
        End If
        If (Not lo_Node.Expanded) And (ll_LvlIdx <> UBound(av_PathData)) Then
            If Not ab_Expand Then GoTo CleanUp
            Call ao_Tree.ExpandNode(lo_Node)
        End If
    Next
    
    Set FindInTreeView = lo_Node
        
CleanUp:
    Set lo_Node = Nothing
    mb_InternalInit = lb_Internal
    Exit Function
ErrHandler:
    Set lo_Node = Nothing
    mb_InternalInit = lb_Internal
    Call ErrorHandler("FindInTreeView")
End Function

Private Function GetCurrentPathData(ByRef ao_data As Dictionary, ByVal as_Path As String) As Variant
On Error GoTo ErrHandler

    Dim las_Paths() As String, lv_pathData As Variant
    Dim ll_IdxPath As Long
    Dim lsa_Pattern As Variant
    Dim ll_i As Long
        
        las_Paths = Split(as_Path, SEP)
        ReDim lv_pathData(LBound(las_Paths) To UBound(las_Paths))
        
        For ll_IdxPath = LBound(las_Paths) To UBound(las_Paths)
            lsa_Pattern = Split(las_Paths(ll_IdxPath), SEP1)
            
            For ll_i = LBound(lsa_Pattern) To UBound(lsa_Pattern)
                If ao_data.Exists(lsa_Pattern(ll_i)) Then
                    lsa_Pattern(ll_i) = ao_data.Item(lsa_Pattern(ll_i))
                Else
                    lsa_Pattern(ll_i) = "MISSING DATA:"
                End If
            Next ll_i
            lv_pathData(ll_IdxPath) = lsa_Pattern
        Next ll_IdxPath
        
        GetCurrentPathData = lv_pathData
    Exit Function

ErrHandler:
    Call ErrorHandler("GetCurrentPathData")

End Function

Private Function DeleteNode(ByRef ao_TreeView As ArmTreeView, ByRef ao_Node As Node) As Node
On Error GoTo ErrHandler

    Dim lo_Node As Node, lo_parentNode As Node, lo_PreviousNode As Node

    Set lo_Node = ao_Node
    
    While Not lo_Node Is Nothing
        Call lo_Node.Tag.SetData(3, Val(lo_Node.Tag.GetData(3)) - 1)
        Set lo_Node = lo_Node.Parent
    Wend
    
    Set lo_Node = ao_Node
    Do While (lo_Node.Tag.GetData(3) = 0)
        Set lo_parentNode = lo_Node.Parent
        Set lo_PreviousNode = lo_Node.Previous
        Call ao_TreeView.RemoveNode(lo_Node)
        Set lo_Node = lo_parentNode
        If lo_Node Is Nothing Then Exit Do
    Loop
    Set ao_Node = Nothing

    Set DeleteNode = IIf(lo_parentNode Is Nothing, lo_PreviousNode, lo_parentNode)
    Exit Function
    
ErrHandler:
    If (Not lo_Node Is Nothing) Then Set lo_Node = Nothing
    If (Not lo_parentNode Is Nothing) Then Set lo_parentNode = Nothing
    If (Not lo_PreviousNode Is Nothing) Then Set lo_PreviousNode = Nothing
    Call ErrorHandler("DeleteNode")

End Function

'to check if updated or added item conform filter
'(there is no filter at this time but it is prepared)
Private Function IsItemInFilter(ByRef ao_data As Dictionary) As Boolean
On Error GoTo ErrHandler

Dim lb_CheckDone As Boolean

    IsItemInFilter = IsItemInFilterCustom(ao_data, lb_CheckDone)
    If lb_CheckDone Then Exit Function
    
    IsItemInFilter = True
    Exit Function
ErrHandler:
    Call ErrorHandler("IsItemInFilter")
End Function

Private Sub Controls_LoadDefaultValue(ByRef av_ListFieldsDefaultValue As Variant)
On Error GoTo ErrHandler

    Dim ll_Idx As Long, ll_Count As Long
    Dim lv_Params As Variant
    Dim lo_Control As Object
    Dim ls_value As String

    ll_Count = UBound(av_ListFieldsDefaultValue)

    For ll_Idx = 0 To ll_Count
            Set lo_Control = av_ListFieldsDefaultValue(ll_Idx)(0)
            Select Case UCase(TypeName(lo_Control))
                Case "FRAME", "LABEL", "MSFLEXGRID", "TOOLBARCONTROL"
                    ' Do nothing !
                Case "TEXTBOX"
                    lo_Control.Text = av_ListFieldsDefaultValue(ll_Idx)(1)
                Case "A_CALOCX"
                    ls_value = av_ListFieldsDefaultValue(ll_Idx)(1)
                    If StrComp(ls_value, "Date") = 0 Then
                        lo_Control.date_courte = Format(Date, "dd\/mm\/yyyy")
                    ElseIf StrComp(Left(ls_value, 5), "Date+") = 0 Then
                        lo_Control.date_courte = Format(Date + CLng(Mid(ls_value, 6)), "dd\/mm\/yyyy")
                    ElseIf StrComp(Left(ls_value, 5), "Date-") = 0 Then
                        lo_Control.date_courte = Format(Date - CLng(Mid(ls_value, 6)), "dd\/mm\/yyyy")
                    Else
                        lo_Control.date_courte = ls_value
                    End If
                Case "ARMGRID", "ARMCHECKVIEW", "COMMANDBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TABSTRIP"
                
                Case "OPTIONBUTTON", "CHECKBOX"
                    lo_Control.Value = av_ListFieldsDefaultValue(ll_Idx)(1)
                Case "ARMCOMBOBOX"
                    lv_Params = Split(av_ListFieldsDefaultValue(ll_Idx)(1), SEP)
                    If Not lo_Control.SearchItem(lv_Params(0)) Then
                        If UBound(lv_Params) >= 1 Then
                            Call lo_Control.AddItem(Array(lv_Params(0), lv_Params(1)))
                        Else
                            Call lo_Control.Load ' load only once and remember found default value. Do not use any hardcoded default value
                            If lo_Control.SearchItem(lv_Params(0)) Then
                                av_ListFieldsDefaultValue(ll_Idx)(1) = lv_Params(0) & SEP & lo_Control.Text
                            End If
                        End If
                    End If
                Case "ARMPICKER"
                    lv_Params = Split(av_ListFieldsDefaultValue(ll_Idx)(1), SEP)
                    lo_Control.ItemCode = lv_Params(0)
                    If UBound(lv_Params) >= 1 Then
                        lo_Control.ItemDescription = lv_Params(1)
                    End If
                                    
                Case Else
                    Debug.Print "Controls_LoadDefaultValue " & UCase(TypeName(lo_Control))
            End Select
    Next
    Set lo_Control = Nothing
    Exit Sub
ErrHandler:
    Call ErrorHandler("Controls_LoadDefaultValue")
End Sub

Private Function GetTreeViewInfo(ByRef aTVInfos() As TTreeViewInfo, ByVal AScreenName As String, ByVal aTVCode As String) As TTreeViewInfo
On Error GoTo ErrHandler
    Dim lIdx As Long, lCount As Long
    Dim lTreeView As TTreeViewInfo, lFound As Boolean
    
    ' Search in the array
    lCount = UBound(aTVInfos)
    lFound = False
    For lIdx = 0 To lCount
        If aTVInfos(lIdx).TreeViewCode = aTVCode Then
            If Not aTVInfos(lIdx).Loaded Then
                aTVInfos(lIdx) = GetTreeViewInfoFromDB(AScreenName, aTVCode)
            End If
            lTreeView = aTVInfos(lIdx)
            lFound = True
            Exit For
        End If
    Next
    
    If Not lFound Then
        Call Err.Raise(ArmErr.InvalidArgument, "TreeviewInfo", "TreeViewInfo not found. AScreenName=" & AScreenName & " aTVCode=" & aTVCode)
    End If
    
    GetTreeViewInfo = lTreeView
    Exit Function
ErrHandler:
    Call ErrorHandler("GetTreeViewInfo")

End Function

Private Function ApplyTVFilters(ByVal av_Request As Variant) As Variant
On Error GoTo ErrHandler
    Dim lv_Requests As Variant
    
    If IsArray(av_Request) Then
        ReDim lv_Requests(UBound(av_Request))
        Dim ll_Idx As Long, ll_Count As Long
        ll_Count = UBound(lv_Requests)
        For ll_Idx = 0 To ll_Count
            lv_Requests(ll_Idx) = ReplaceTVFiltersHolders(av_Request(ll_Idx))
            lv_Requests(ll_Idx) = ReplaceLanguagePlaceholderFromToolbar(lv_Requests(ll_Idx))
            lv_Requests(ll_Idx) = ReplaceCommonPlaceholders(lv_Requests(ll_Idx))
        Next
    Else
        ReDim lv_Requests(0)
        lv_Requests(0) = ReplaceTVFiltersHolders(av_Request)
        lv_Requests(0) = ReplaceLanguagePlaceholderFromToolbar(lv_Requests(0))
        lv_Requests(0) = ReplaceCommonPlaceholders(lv_Requests(0))
    End If

    ApplyTVFilters = lv_Requests
    Exit Function
ErrHandler:
    Call ErrorHandler("ApplyTVFilters")
End Function

' placeholders are no more part of request
Private Function DeleteGridFilterPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler
    as_Request = ReplacePlaceHolder(as_Request, ",$CCU_town$", "")
    as_Request = ReplacePlaceHolder(as_Request, ",$SP_CapKey$", "")
    as_Request = ReplacePlaceHolder(as_Request, ",$SPA_Comment$", "")

    DeleteGridFilterPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("DeleteGridFilterPlaceholders")
End Function

Private Function RemoveGridFilterPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler
    as_Request = ReplacePlaceHolder(as_Request, "$CCU_town$", "NULL")
    as_Request = ReplacePlaceHolder(as_Request, "$SP_CapKey$", "NULL")
    as_Request = ReplacePlaceHolder(as_Request, "$SPA_Comment$", "''")
    as_Request = ReplacePlaceHolder(as_Request, "$CCU_Desc$", "''")
    as_Request = ReplacePlaceHolder(as_Request, "$SPA_ID$", "''")
    as_Request = ReplacePlaceHolder(as_Request, "$BI_SAP_Code$", "''")

    RemoveGridFilterPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("RemoveGridFilterPlaceholders")
End Function

Private Function ReplaceGridFilterPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler
    
    as_Request = ReplacePlaceholderByControlValue(as_Request, cbo_CCU_Town)
    as_Request = ReplacePlaceholderByControlValue(as_Request, cbo_Project)
    as_Request = ReplacePlaceholderByControlValue(as_Request, txt_Comment)
    as_Request = ReplacePlaceholderByControlValue(as_Request, txt_CustName)
    as_Request = ReplacePlaceholderByControlValue(as_Request, txt_SPAID)
    as_Request = ReplacePlaceholderByControlValue(as_Request, txt_itemNb)

    ReplaceGridFilterPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceGridFilterPlaceholders")
End Function

Private Function ReplaceTVFiltersHolders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

    Dim ls_Request As String

    ls_Request = ReplaceRequestByFrameData(as_Request, fra_MainFilter)
    ls_Request = ReplacePlaceholderByControlValue(ls_Request, tbs_ProjectType)
    ls_Request = ReplacePlaceholderByControlValue(ls_Request, tbs_Status)
    ReplaceTVFiltersHolders = ls_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceTVFiltersHolders")
End Function

Private Function ReplaceTVHolders(ByVal as_Request As String) As String
On Error GoTo ErrHandler
    Dim ls_Buffer As String
    
    ls_Buffer = ReplacePlaceHolder(as_Request, "$language_code$", SQLStr(ms_Language_Code))
    ls_Buffer = ReplacePlaceHolder(ls_Buffer, "$u_code$", ml_U_Code)
    ReplaceTVHolders = ls_Buffer
    
CleanUp:
    Exit Function

ErrHandler:
    Call ErrorHandler("ReplaceTVHolders")
End Function

Private Sub ReloadMainGrid()
On Error GoTo ErrHandler

    If tvw_Main.Checkboxes = True Then
        grd_main.Requests = ApplyGridFilters(ApplyTVFilters(tvw_Main.CheckedNodesRequests), Not mb_filtersVisible)
    Else
        grd_main.Requests = ApplyGridFilters(ApplyTVFilters(tvw_Main.SelectedNodeRequest), Not mb_filtersVisible)
    End If
    
    If grd_main.Execute = False Then
        Err.Raise ArmErr.CompFncFailed, "grd_Main.Execute", "Load grid failed"
    End If
    
    Call grd_SPA_Detail.ClearGrid
    grd_SPA_Detail.Visible = False
    
    mt_MainConfig.CurrentTvwSelMethod = IIf(tvw_Main.Checkboxes, eTvwSelMethod.etmCheckBoxes, eTvwSelMethod.etmBranch)
    Call UpdateMainToolbarCustom
    Exit Sub
ErrHandler:
    Call ErrorHandler("ReloadMainGrid")
End Sub

Private Sub ReloadMainTreeview()
On Error GoTo ErrHandler
    
    mb_InternalInit = True
    Dim lb_Grid As Boolean
    
    If mt_MainConfig.HasTreeview Then
        tvw_Main.Refresh
        Call ReloadMainGrid
    End If
    mb_InternalInit = False
    
    Exit Sub
ErrHandler:
    mb_InternalInit = False
    Call ErrorHandler("ReloadMainTreeview")
End Sub

Private Function ApplyGridFilters(ByVal av_Request As Variant, ByVal ab_remove As Boolean) As Variant
On Error GoTo ErrHandler
    Dim lv_Requests As Variant
    
    If IsArray(av_Request) Then
        ReDim lv_Requests(UBound(av_Request))
        Dim ll_Idx As Long, ll_Count As Long
        ll_Count = UBound(lv_Requests)
        For ll_Idx = 0 To ll_Count
            If ab_remove Then
                lv_Requests(ll_Idx) = RemoveGridFilterPlaceholders(av_Request(ll_Idx))
            Else
                lv_Requests(ll_Idx) = ReplaceGridFilterPlaceholders(av_Request(ll_Idx))
            End If
        Next
    Else
        ReDim lv_Requests(0)
        If ab_remove Then
            lv_Requests(0) = RemoveGridFilterPlaceholders(av_Request)
        Else
            lv_Requests(0) = ReplaceGridFilterPlaceholders(av_Request)
        End If
    End If

    ApplyGridFilters = lv_Requests
    Exit Function
ErrHandler:
    Call ErrorHandler("ApplyTVFilters")
End Function

Private Sub ReloadMainFilterGrid()
On Error GoTo ErrHandler
    
    mb_InternalInit = True
    Dim lb_Grid As Boolean
    Dim ls_Request As String

    If grd_main.Cols = 0 Then
        If Not grd_main.SetColumns(mt_MainConfig.MainGridColumns) Then
            Err.Raise ArmErr.CompFncFailed, "grd_Main", "Method SetColumns failed."
        End If

        If Not grd_SPA_Detail.SetColumns(mt_MainConfig.SubGridColumns) Then
            Err.Raise ArmErr.CompFncFailed, "grd_SPA_Detail", "Method SetColumns failed."
        End If

        Call LoadLabels(mo_Db, fra_MainItem, SCREEN_NAME, ms_Language_Code)
    End If
    
    ls_Request = mt_MainConfig.GridRequest
    ls_Request = ReplaceRequestByFrameData(ls_Request, fra_MainFilter)
    ls_Request = ReplaceLanguagePlaceholderFromToolbar(ls_Request)
    ls_Request = ReplaceCommonPlaceholders(ls_Request)

    If Not grd_main.Load(ApplyGridFilters(ls_Request, True), False, , , True) Then
        Err.Raise ArmErr.CompFncFailed, "grd_Main().Load", "Load grid failed: " & ls_Request
    End If

    Call grd_SPA_Detail.ClearGrid
    
    mb_InternalInit = False
    
    Exit Sub
ErrHandler:
    mb_InternalInit = False
    Call ErrorHandler("ReloadMainTreeview")
End Sub

Public Sub AddDroppedCheckItems(ByRef ao_chkview As ArmCheckView)
On Error GoTo ErrHandler

Dim ll_Index As Long
Dim ll_Count As Long
Dim lo_ItemInfo As ArmItemInfo

    ll_Count = ao_chkview.RoleList("VIEW").Count
    For ll_Index = 1 To ll_Count
        If ao_chkview.RoleList("EDIT").GetItem(ao_chkview.RoleList("VIEW").GetKey(ll_Index)) Is Nothing Then
            Set lo_ItemInfo = ao_chkview.RoleList("VIEW").Items(ll_Index)
            Call ao_chkview.RoleList("EDIT").AddItemInfo(Array(lo_ItemInfo.GetData(0), lo_ItemInfo.GetData(1), 1), True, True)
        End If
    Next
    Call ao_chkview.RoleList("EDIT").DisplayList
    Exit Sub
ErrHandler:
    Call ErrorHandler("AddDroppedCheckItems")
End Sub

Public Sub RemoveDroppedCheckItems(ByRef ao_chkview As ArmCheckView)
On Error GoTo ErrHandler

Dim ll_Index As Long
Dim ll_Count As Long
Dim lo_ItemInfo As ArmItemInfo

    ll_Count = ao_chkview.RoleList("EDIT").Count
    For ll_Index = ll_Count To 1 Step -1
        Set lo_ItemInfo = ao_chkview.RoleList("EDIT").Items(ll_Index)
        If UBound(lo_ItemInfo.Data) > 1 Then
            Call ao_chkview.RoleList("EDIT").Items.Remove(ll_Index)
        End If
        Set lo_ItemInfo = Nothing
    Next
    Call ao_chkview.RoleList("EDIT").DisplayList
    Exit Sub
ErrHandler:
    Call ErrorHandler("RemoveDroppedCheckItems")
End Sub

Private Sub LoadListView(ByVal ao_ListView As MSComctlLib.ListView, ByVal as_Request As String)
On Error GoTo ErrHandler

Dim ll_cursor As Long
Dim lo_item As MSComctlLib.ListItem
Dim lo_SubItem As MSComctlLib.ListSubItem
Dim ll_Index As Long

    Call ao_ListView.ListItems.Clear
    ll_cursor = mo_Db.OpenSQL(as_Request)
    If ll_cursor > 0 Then
        While Not mo_Db.EOF(ll_cursor)
            Set lo_item = ao_ListView.ListItems.Add(, "KEY" & mo_Db.GetFields(ll_cursor, 0), mo_Db.GetFields(ll_cursor, 1))
            If mo_Db.FieldCount(ll_cursor) > 2 Then
                For ll_Index = 2 To mo_Db.FieldCount(ll_cursor) - 1
                    Set lo_SubItem = lo_item.ListSubItems.Add(, , mo_Db.GetFields(ll_cursor, ll_Index))
                Next
            End If
            Call mo_Db.Next(ll_cursor)
        Wend
        Call mo_Db.Close(ll_cursor)
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler("LoadListView")
End Sub

Private Sub CheckListView(ByVal ao_ListView As MSComctlLib.ListView, ByVal as_Request As String)
On Error GoTo ErrHandler

Dim ll_cursor As Long
Dim lo_item As MSComctlLib.ListItem
Dim lo_NewItem As MSComctlLib.ListItem
Dim ls_ItemKey As String, ls_ItemText As String

    For Each lo_item In ao_ListView.ListItems
        lo_item.Checked = False
        lo_item.Tag = ""
    Next lo_item
    ll_cursor = mo_Db.OpenSQL(as_Request)
    If ll_cursor > 0 Then
        While Not mo_Db.EOF(ll_cursor)
            For Each lo_item In ao_ListView.ListItems
                If StrComp(lo_item.Key, "KEY" & mo_Db.GetFields(ll_cursor, 0), vbTextCompare) = 0 Then
                    ls_ItemText = lo_item.Text
                    ls_ItemKey = lo_item.Key
                    Call ao_ListView.ListItems.Remove(lo_item.Index)
                    Set lo_NewItem = ao_ListView.ListItems.Add(1, ls_ItemKey, ls_ItemText)
                    lo_NewItem.Checked = True
                    lo_NewItem.Tag = "X"
                    Exit For
                End If
            Next lo_item
            Call mo_Db.Next(ll_cursor)
        Wend
        Call mo_Db.Close(ll_cursor)
    End If
    Call ao_ListView.Refresh
    Exit Sub
ErrHandler:
    Call ErrorHandler("CheckListView")
End Sub

Private Sub ClearCollection(ByVal ao_Collection As Collection)
On Error GoTo ErrHandler

    While ao_Collection.Count > 0
        Call ao_Collection.Remove(1)
    Wend
    Exit Sub
ErrHandler:
    Call ErrorHandler("ClearCollection")
End Sub


Private Function SqlInt(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlInt = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlInt = CStr(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlInt")
End Function

Private Function SqlDbl(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDbl = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If Trim(CStr(av_Data)) <> "" Then
        SqlDbl = Str(av_Data)
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlDbl")
End Function

Private Function SqlDate(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlDate")
End Function


Private Function SQLStr(ByVal as_Data As String) As String
On Error GoTo ErrHandler

    SQLStr = "'" & Replace(as_Data, "'", "''") & "'"
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlStr")
End Function

Private Function GetComboKey(ByVal ao_Combo As ArmCombobox) As String
On Error GoTo ErrHandler

    GetComboKey = ""
    If Not (ao_Combo.SelectedItem Is Nothing) Then
        GetComboKey = Trim(CStr(ao_Combo.SelectedItem.Key))
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetComboKey")
End Function

Private Function CustomReplacePlaceholder(ByRef as_Request As String, ByVal as_PlaceHolder As String, ByVal as_DefaultValue As String) As Boolean
On Error GoTo ErrHandler

    If (StrComp(as_PlaceHolder, "$FRI_Language_Code$", vbTextCompare) = 0) And (as_DefaultValue = "''") Then
        as_Request = Replace(as_Request, as_PlaceHolder, "NULL", , , vbTextCompare)
        CustomReplacePlaceholder = True
    ElseIf (StrComp(as_PlaceHolder, "$DHG_Language_Code$", vbTextCompare) = 0) And (as_DefaultValue = "''") Then
        as_Request = Replace(as_Request, as_PlaceHolder, "NULL", , , vbTextCompare)
        CustomReplacePlaceholder = True
    End If
    CustomReplacePlaceholder = False
    Exit Function
ErrHandler:
    Call ErrorHandler("CustomReplacePlaceholder")
End Function

Private Function ReplacePlaceHolder(ByVal as_Request As String, ByVal as_PlaceHolder As String, ByVal as_DefaultValue As String) As String
On Error GoTo ErrHandler
    
    If Not CustomReplacePlaceholder(as_Request, as_PlaceHolder, as_DefaultValue) Then
        as_Request = Replace(as_Request, as_PlaceHolder, as_DefaultValue, , , vbTextCompare)
    End If
    ReplacePlaceHolder = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplacePlaceholder")
End Function

Private Function ReplaceKeyPlaceholders(ByVal as_Request As String, ByVal av_Key As Variant) As String
On Error GoTo ErrHandler

Dim ll_Index As Long

    If Not IsArray(av_Key) Then av_Key = Array(av_Key)
    
    For ll_Index = 0 To UBound(av_Key)
        as_Request = ReplacePlaceHolder(as_Request, "$Key" & (ll_Index + 1) & "$", SQLStr(av_Key(ll_Index)))
    Next
    ReplaceKeyPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceKeyPlaceholders")
End Function

Private Function ReplaceLanguagePlaceholderFromToolbar(ByVal as_Request As String) As String
On Error GoTo ErrHandler
    
    ReplaceLanguagePlaceholderFromToolbar = ReplacePlaceHolder(as_Request, "$toolbar_language_code$", SQLStr(tlb_main.Language))
    
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceLanguagePlaceholderFromToolbar")
End Function

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

    as_Request = ReplacePlaceHolder(as_Request, "$language_code$", SQLStr(ms_Language_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$Z_Creator$", SqlInt(ml_U_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$U_Code$", SqlInt(ml_U_Code))
    as_Request = ReplacePlaceHolder(as_Request, "$Z_Last_Upd_User$", SqlInt(ml_U_Code))
    ReplaceCommonPlaceholders = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceCommonPlaceholders")
End Function

Private Function ReplacePlaceholderByControlValue(ByVal as_Request As String, ByRef ao_Control As Object) As String
On Error GoTo ErrHandler

Dim lsa_Columns() As String

    If Trim(ao_Control.Tag) = "" Then
        ReplacePlaceholderByControlValue = as_Request
        Exit Function
    End If
    
    Select Case UCase(TypeName(ao_Control))
        Case "ARMCOMBOBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            
            If UBound(lsa_Columns) >= 0 Then
                If GetComboKey(ao_Control) = "" Then
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                Else
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(GetComboKey(ao_Control)))
                End If
            End If
            If UBound(lsa_Columns) >= 1 Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(1) & "$", SQLStr(ao_Control.Text))
            End If
        Case "ARMPICKER"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            
            If UBound(lsa_Columns) >= 0 Then
                If (Trim(CStr(ao_Control.ItemCode)) = "") Or (CStr(ao_Control.ItemCode) = "0") Then
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                Else
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(Trim(CStr(ao_Control.ItemCode))))
                End If
            End If
            If UBound(lsa_Columns) >= 1 Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(1) & "$", SQLStr(Trim(ao_Control.ItemDescription)))
            End If
        Case "OPTIONBUTTON"
            If ao_Control.Value = True Then
                lsa_Columns = Split(ao_Control.Tag, SEP)
                If UBound(lsa_Columns) > 0 Then
                    Select Case UCase(lsa_Columns(1))
                    Case "N"
                        as_Request = ReplacePlaceHolder(as_Request, "$" & ao_Control.Name & "$", ao_Control.Index)
                    Case Else
                        as_Request = ReplacePlaceHolder(as_Request, "$" & ao_Control.Name & "$", SQLStr(lsa_Columns(0)))
                    End Select
                Else
                    as_Request = ReplacePlaceHolder(as_Request, "$" & ao_Control.Name & "$", SQLStr(lsa_Columns(0)))
                End If
            End If
        Case "CHECKBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If ao_Control.Value = vbChecked Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr("X"))
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(""))
            End If
        Case "TEXTBOX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If UBound(lsa_Columns) > 0 Then
                Select Case UCase(lsa_Columns(1))
                Case "N"
                    If ao_Control.Text = "" Then
                       as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
                    Else
                       as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", ao_Control.Text)
                    End If
                Case Else
                    as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.Text))
                End Select
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.Text))
            End If
        Case "A_CALOCX"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SqlDate(ao_Control.date_dt))
        Case "TABSTRIP"
            lsa_Columns = Split(ao_Control.Tag, SEP)
            If ao_Control.SelectedItem Is Nothing Then
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", "NULL")
            Else
                as_Request = ReplacePlaceHolder(as_Request, "$" & lsa_Columns(0) & "$", SQLStr(ao_Control.SelectedItem.Key))
            End If
    End Select
    ReplacePlaceholderByControlValue = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplacePlaceholderByControlValue")
End Function

Private Function HasContainer(ByVal lo_Control As Control, ByRef lo_Container As Object) As Boolean
    Dim ll_Index As Long
    Dim lo_Object As Object

    On Error GoTo CleanUp   'not all controls support Container property
    HasContainer = False
    While Not (lo_Control Is Nothing)
        If lo_Control.Container Is lo_Container Then
            HasContainer = True
            Exit Function
        End If
        Set lo_Control = lo_Control.Container
    Wend

CleanUp:

End Function


Private Function ReplaceRequestByFrameData(ByVal as_Request As String, ByVal ao_Frame As Frame)
On Error GoTo ErrHandler

Dim lo_Control As Control
   
    For Each lo_Control In UserControl.Controls
        If HasContainer(lo_Control, ao_Frame) Then
            as_Request = ReplacePlaceholderByControlValue(as_Request, lo_Control)
        End If
    Next
    ReplaceRequestByFrameData = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceRequestByFrameData")
End Function

Private Function ReplaceRequestByGridData(ByVal ao_grid As ArmGrid, ByVal as_Request As String, ByVal al_Row As Long, ByVal as_Table As String) As String
On Error GoTo ErrHandler

Dim ll_ColIndex As Long
Dim ls_Data As String
    
    For ll_ColIndex = 0 To ao_grid.Cols - 1
'        If ao_Grid.Columns(ll_ColIndex).Key And (as_Table <> "") And (ao_Grid.Data(al_Row, STATUS_COLUMN) = "A") Then
'            ls_Data = SqlInt(ao_Grid.Data(al_Row, ll_ColIndex))
'            If (ls_Data = "0") Or (ls_Data = "NULL") And (as_Table <> "") Then
'                ls_Data = mo_Db.SQLNextID(as_Table)
'                If ls_Data = "" Then
'                    Err.Raise ArmErr.CompFncFailed, "mo_Db.SQLNextID", "SQLNextID failed for: " & as_Table
'                End If
'            End If
'        Else
        Select Case ao_grid.Columns(ll_ColIndex).FieldType
        Case DBTYPE_I4
            ls_Data = SqlInt(ao_grid.Data(al_Row, ll_ColIndex))
        Case DBTYPE_R4, DBTYPE_R8
            ls_Data = SqlDbl(ao_grid.Data(al_Row, ll_ColIndex))
        Case DBTYPE_DATE
            ls_Data = SqlDate(ao_grid.Data(al_Row, ll_ColIndex))
        Case DBTYPE_BMP
            Select Case UCase(ao_grid.Data(al_Row, ll_ColIndex))
            Case "CHECK"
                ls_Data = SQLStr("X")
            Case "UNCHECK"
                ls_Data = SQLStr("")
            End Select
        Case Else
            ls_Data = SQLStr(ao_grid.Data(al_Row, ll_ColIndex))
        End Select
        as_Request = ReplacePlaceHolder(as_Request, "$" & ao_grid.Columns(ll_ColIndex).Name & "$", ls_Data)
    Next
    ReplaceRequestByGridData = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceRequestByGridData")
End Function

Private Function ReplaceRequestByGridStoredData(ByVal ao_grid As ArmGrid, ByVal ao_Collection As Collection, ByVal as_Request As String, ByVal al_Row As Long, ByVal as_Table As String) As String
On Error GoTo ErrHandler

Dim ll_ColIndex As Long
Dim ls_Data As String
    
    For ll_ColIndex = 0 To ao_grid.Cols - 1
        Select Case ao_grid.Columns(ll_ColIndex).FieldType
        Case DBTYPE_I4
            ls_Data = SqlInt(ao_Collection(al_Row)(ll_ColIndex))
        Case DBTYPE_R4, DBTYPE_R8
            ls_Data = SqlDbl(ao_Collection(al_Row)(ll_ColIndex))
        Case DBTYPE_DATE
            ls_Data = SqlDate(ao_Collection(al_Row)(ll_ColIndex))
        Case DBTYPE_BMP
            Select Case UCase(ao_Collection(al_Row)(ll_ColIndex))
            Case "CHECK"
                ls_Data = SQLStr("X")
            Case "UNCHECK"
                ls_Data = SQLStr("")
            End Select
        Case Else
            ls_Data = SQLStr(ao_Collection(al_Row)(ll_ColIndex))
        End Select
        as_Request = ReplacePlaceHolder(as_Request, "$" & ao_grid.Columns(ll_ColIndex).Name & "$", ls_Data)
    Next
    ReplaceRequestByGridStoredData = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceRequestByGridStoredData")
End Function

Private Sub LoadFrameDataFromCursor(ByVal ao_DB As ArmDb, ByVal al_cursor As Long, ByVal ao_Frame As Frame)
On Error GoTo ErrHandler

Dim lo_Control As Control
Dim lsa_Columns() As String
Dim lv_ComboData As Variant
Dim ll_Index As Long


   mb_InternalInit = True
    For Each lo_Control In UserControl.Controls
    
        If HasContainer(lo_Control, ao_Frame) Then
            Select Case UCase(TypeName(lo_Control))
                Case "ARMCOMBOBOX"
                    If Trim(lo_Control.Tag) <> "" Then
                        lsa_Columns = Split(lo_Control.Tag, SEP)
                        If (StrComp(mo_Db.GetFields(al_cursor, lsa_Columns(0)), "", vbTextCompare) <> 0) And _
                            (StrComp(mo_Db.GetFields(al_cursor, lsa_Columns(0)), "0", vbTextCompare) <> 0) Then
                            If UBound(lsa_Columns) >= 1 Then
                                If Not lo_Control.SearchItem(mo_Db.GetFields(al_cursor, lsa_Columns(0))) Then
                                    ReDim lv_ComboData(UBound(lsa_Columns))
                                    For ll_Index = 0 To UBound(lsa_Columns)
                                        lv_ComboData(ll_Index) = mo_Db.GetFields(al_cursor, lsa_Columns(ll_Index))
                                    Next
                                    If lo_Control.AddItem(lv_ComboData, True) Is Nothing Then
                                        Err.Raise ArmErr.CompFncFailed, lo_Control.Name, "Function AddItem failed"
                                    End If
                                End If
                            Else
                                Call lo_Control.SearchItem(mo_Db.GetFields(al_cursor, lsa_Columns(0)))
                            End If
                        End If
                    End If
                Case "ARMPICKER"
                    If Trim(lo_Control.Tag) <> "" Then
                        lsa_Columns = Split(lo_Control.Tag, SEP)
                        If (StrComp(mo_Db.GetFields(al_cursor, lsa_Columns(0)), "", vbTextCompare) <> 0) And _
                            (StrComp(mo_Db.GetFields(al_cursor, lsa_Columns(0)), "0", vbTextCompare) <> 0) Then
                            If UBound(lsa_Columns) >= 1 Then
                                lo_Control.ItemCode = mo_Db.GetFields(al_cursor, lsa_Columns(0))
                                lo_Control.ItemDescription = mo_Db.GetFields(al_cursor, lsa_Columns(1))
                            End If
                        End If
                    End If
                Case "CHECKBOX"
                    If Trim(lo_Control.Tag) <> "" Then
                        lsa_Columns = Split(lo_Control.Tag, SEP)
                        If UCase(mo_Db.GetFields(al_cursor, lsa_Columns(0))) = "X" Then
                            lo_Control.Value = vbChecked
                        Else
                            lo_Control.Value = vbUnchecked
                        End If
                    End If
                Case "TEXTBOX"
                    If Trim(lo_Control.Tag) <> "" Then
                        lsa_Columns = Split(lo_Control.Tag, SEP)
                        lo_Control.Text = mo_Db.GetFields(al_cursor, lsa_Columns(0))
                    End If
                Case "A_CALOCX"
                    If Trim(lo_Control.Tag) <> "" Then
                        If CDbl(mo_Db.GetFields(al_cursor, lo_Control.Tag)) = 0 Then
                            Call lo_Control.reinit_cal
                        Else
                            lo_Control.date_courte = Format(mo_Db.GetFields(al_cursor, lo_Control.Tag), "dd\/mm\/yyyy")
                        End If
                    End If
            End Select
        End If
    Next
    mb_InternalInit = False
    Exit Sub
ErrHandler:
    mb_InternalInit = False
    Call ErrorHandler("LoadFrameDataFromCursor")
End Sub

Private Sub LoadFrameDataFromGrid(ByVal ao_grid As ArmGrid, ByVal ao_Frame As Frame)
On Error GoTo ErrHandler

Dim lo_Control As Control
Dim lsa_Columns() As String
Dim lv_ComboData As Variant
Dim ll_Index As Long
   
   mb_InternalInit = True
    If ao_grid.SelectedCount <> 1 Then
        Debug.Assert True
        mb_InternalInit = False
        Exit Sub
    End If
    
    For Each lo_Control In UserControl.Controls
    
        If HasContainer(lo_Control, ao_Frame) Then
            Select Case UCase(TypeName(lo_Control))
                Case "ARMCOMBOBOX"
                    If Trim(lo_Control.Tag) <> "" Then
                        lsa_Columns = Split(lo_Control.Tag, SEP)
                        If UBound(lsa_Columns) >= 1 Then
                            If Not lo_Control.SearchItem(ao_grid.CurrentLine(lsa_Columns(0))) Then
                                ReDim lv_ComboData(UBound(lsa_Columns))
                                For ll_Index = 0 To UBound(lsa_Columns)
                                    lv_ComboData(ll_Index) = ao_grid.CurrentLine(lsa_Columns(ll_Index))
                                Next
                                If lo_Control.AddItem(lv_ComboData, True) Is Nothing Then
                                    Err.Raise ArmErr.CompFncFailed, lo_Control.Name, "Function AddItem failed"
                                End If
                            End If
                        Else
                            Call lo_Control.SearchItem(ao_grid.CurrentLine(lsa_Columns(0)))
                        End If
                    End If
                Case "ARMPICKER"
                    If Trim(lo_Control.Tag) <> "" Then
                        lsa_Columns = Split(lo_Control.Tag, SEP)
                        If UBound(lsa_Columns) >= 1 Then
                            lo_Control.ItemCode = ao_grid.CurrentLine(lsa_Columns(0))
                            lo_Control.ItemDescription = ao_grid.CurrentLine(lsa_Columns(1))
                        End If
                    End If
                Case "CHECKBOX"
                    If Trim(lo_Control.Tag) <> "" Then
                        If (StrComp(ao_grid.CurrentLine(lo_Control.Tag), "X", vbTextCompare) = 0) Or _
                           (StrComp(ao_grid.CurrentLine(lo_Control.Tag), "CHECK", vbTextCompare) = 0) Then
                            lo_Control.Value = vbChecked
                        Else
                            lo_Control.Value = vbUnchecked
                        End If
                    End If
                Case "TEXTBOX"
                    If Trim(lo_Control.Tag) <> "" Then
                        lo_Control.Text = ao_grid.CurrentLine(lo_Control.Tag)
                    End If
                Case "A_CALOCX"
                    If Trim(lo_Control.Tag) <> "" Then
                        If CDbl(ao_grid.CurrentLine(lo_Control.Tag)) = 0 Then
                            Call lo_Control.reinit_cal
                        Else
                            lo_Control.date_courte = Format(ao_grid.CurrentLine(lo_Control.Tag), "dd\/mm\/yyyy")
                        End If
                    End If
            End Select
        End If
    Next
    mb_InternalInit = False
    Exit Sub
ErrHandler:
    mb_InternalInit = False
    Call ErrorHandler("LoadFrameDataFromGrid")
End Sub

Private Function SelectValue(ByVal as_Request As String) As Variant
On Error GoTo ErrHandler
Dim ll_cursor As Long

  ll_cursor = OpenSQLSafe(mo_Db, as_Request)
  If ll_cursor > 0 Then
    If mo_Db.RowCount(ll_cursor) = 1 Then
      SelectValue = mo_Db.GetFields(ll_cursor, 0)
    End If
    Call mo_Db.Close(ll_cursor)
  End If
  Exit Function
ErrHandler:
  Call mo_Db.Close(ll_cursor)
  Call ErrorHandler("SelectValue as_Request=" & as_Request)
End Function

Private Sub UpdateLocalComboboxes(ByVal as_Key As String, ByVal av_Value As Variant, ByVal ae_Mode As eMode)
On Error GoTo ErrHandler

Dim lo_Control As Object
Dim lsa_Fields() As String

    If as_Key = "" Then Exit Sub
    For Each lo_Control In UserControl.Controls
    
        If StrComp(TypeName(lo_Control), "ArmCombobox", vbTextCompare) = 0 Then
            If lo_Control.Tag <> "" Then
                lsa_Fields = Split(lo_Control.Tag, SEP)
                If StrComp(lsa_Fields(0), as_Key, vbTextCompare) = 0 Then
                    Call lo_Control.Clear
                End If
            End If
        End If
    Next
    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateLocalComboboxes")
End Sub

Private Function SearchGrid(ByRef ao_grid As ArmGrid, ByVal av_columns As Variant, ByVal av_Data As Variant, ByVal ab_Select As Boolean) As Boolean
On Error GoTo ErrHandler

Dim ll_RowIdx As Long, ll_ColIdx As Long
Dim lb_Found As Boolean

    lb_Found = False
    For ll_RowIdx = 0 To ao_grid.Rows - 1
        lb_Found = True
        For ll_ColIdx = 0 To UBound(av_columns)
            If StrComp(av_Data(ll_ColIdx), ao_grid.Data(ll_RowIdx, av_columns(ll_ColIdx)), vbTextCompare) <> 0 Then
                lb_Found = False
                Exit For
            End If
        Next
        If lb_Found Then Exit For
    Next
    If lb_Found And ab_Select Then
        ao_grid.Row = ll_RowIdx
    End If
    SearchGrid = lb_Found
    Exit Function
ErrHandler:
    Call ErrorHandler("SearchGrid")
End Function

Private Function GetColIndex(ByRef ao_grid As ArmGrid, ByVal as_ColumnName As String) As Long
On Error GoTo ErrHandler

Dim ll_ColIdx As Long

    For ll_ColIdx = 0 To ao_grid.Cols - 1
        If StrComp(as_ColumnName, ao_grid.Columns(ll_ColIdx).FieldName, vbTextCompare) = 0 Then
            GetColIndex = ll_ColIdx
            Exit Function
        End If
    Next
    GetColIndex = -1
    Exit Function
ErrHandler:
    Call ErrorHandler("GetColIndex")
End Function

Private Function GetTreeViewPath(ByVal ao_Tree As ArmTreeView, ByVal al_dataIndex As Long, ByVal as_Separator As String) As String
On Error GoTo ErrHandler

Dim as_Path As String
Dim lo_Node As MSComctlLib.Node
    
    as_Path = ""
    Set lo_Node = ao_Tree.SelectedItem
    While Not (lo_Node Is Nothing)
    
        If as_Path <> "" Then as_Path = as_Separator & as_Path
        as_Path = lo_Node.Tag.GetData(al_dataIndex) & as_Path
        Set lo_Node = lo_Node.Parent
    Wend
    GetTreeViewPath = as_Path
    Exit Function
ErrHandler:
    Call ErrorHandler("GetTreeViewPath")
End Function

Private Sub ClearFrame(ByRef ao_Controls As Object, ByVal ao_Frame As Frame)
On Error GoTo ErrHandler

Dim ll_Idx As Long, ll_Count As Long, lo_Control As Object

   mb_InternalInit = True
    ll_Count = ao_Controls.Count - 1
    For ll_Idx = 0 To ll_Count
        Set lo_Control = ao_Controls.Item(ll_Idx)
        
        If StrComp(lo_Control.Name, "chk_Repositioning", vbTextCompare) <> 0 Then
        
            If HasContainer(lo_Control, ao_Frame) Then
                Select Case UCase(TypeName(lo_Control))
                    Case "TEXTBOX"
                        lo_Control.Text = ""
                    Case "ARMCOMBOBOX"
                        Set lo_Control.SelectedItem = Nothing
                    Case "ARMPICKER"
                        Call lo_Control.Clear
                    Case "A_CALOCX"
                        lo_Control.reinit_cal
                    Case "CHECKBOX"
                        lo_Control.Value = vbUnchecked
                    Case "ARMCHECKVIEW"
                        Call lo_Control.Init
                        Call RemoveDroppedCheckItems(lo_Control)
                    Case "FRAME", "LABEL", "TOOLBARCONTROL", "PICTUREBOX", "COMMANDBUTTON", _
                         "TABSTRIP", "DRIVELISTBOX", "DIRLISTBOX", "FILELISTBOX", "LISTVIEW"
                        'do nothing
                    Case "ARMGRID"
                        lo_Control.ClearGrid
                        lo_Control.Requests = ""
                    Case "LISTBOX"
                        lo_Control.ListIndex = -1
                    Case "OPTIONBUTTON"
                        Dim lv_Values As Variant
                        lv_Values = Split(lo_Control.Tag, SEP)
                        If UBound(lv_Values) >= 1 Then
                            lo_Control.Value = lv_Values(1)
                        Else
                            lo_Control.Value = False
                        End If
                    Case "ARMTREEVIEW"
                        Call lo_Control.Clear
                    Case Else
                        Debug.Print "ClearFrame " & UCase(TypeName(lo_Control))
                End Select
            End If
        End If
    Next
    Set lo_Control = Nothing
    mb_InternalInit = False
    Exit Sub
ErrHandler:
    Set lo_Control = Nothing
    mb_InternalInit = False
    Call ErrorHandler("ClearFrame")
End Sub

Private Sub EnableFrame(ByRef aControls As Variant, ByRef aContainer As Object, ByVal ab_Enabled As Boolean)
On Error GoTo ErrHandler
    
    Dim lIdx As Long, lCount As Long
    Dim lControl As Control
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
        If HasContainer(lControl, aContainer) Then
            Select Case UCase(TypeName(lControl))
                Case "TOOLBARCONTROL"
                    'lControl.Visible = ab_Enabled
                
                Case "FRAME", "LABEL", "MSFLEXGRID"
                    ' Do nothing !
                
                Case "TEXTBOX"
                    lControl.Locked = Not ab_Enabled
                    lControl.BackColor = IIf(ab_Enabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
                
                Case "ARMGRID", "TABSTRIP"
                
                Case "ARMCHECKVIEW"
                    If ab_Enabled Then
                        Call lControl.SetVisibleList("EDIT")
                    Else
                        Call lControl.SetVisibleList("VIEW")
                    End If
                    
                Case "DIRLISTBOX", "DRIVELISTBOX", "FILELISTBOX"
                    lControl.Enabled = ab_Enabled
                    lControl.BackColor = IIf(ab_Enabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)

                Case "LISTVIEW", "COMMANDBUTTON", "ARMCOMBOBOX", "ARMPICKER", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "CHECKBOX"
                    lControl.Enabled = ab_Enabled
                Case Else
                    lControl.Enabled = ab_Enabled
                    Debug.Print "EnableFrame " & UCase(TypeName(lControl))
            End Select
        End If
        Set lControl = Nothing
    Next
    Exit Sub
ErrHandler:
    If Not lControl Is Nothing Then Set lControl = Nothing
    Call ErrorHandler("EnableFrame")
End Sub

Private Sub DisableFrameParts(ByVal av_ListFieldsToDisable As Variant)
On Error GoTo ErrHandler
    
    Dim lIdx As Long, lCount As Long
    Dim lParams As Variant
    
    If Not IsArray(av_ListFieldsToDisable) Then Exit Sub
    lCount = UBound(av_ListFieldsToDisable)
    
    For lIdx = 0 To lCount
            Select Case UCase(TypeName(av_ListFieldsToDisable(lIdx)))
                Case "FRAME", "LABEL", "MSFLEXGRID", "TOOLBARCONTROL"
                    ' Do nothing !
                
                Case "TEXTBOX"
                        av_ListFieldsToDisable(lIdx).Locked = True
                        av_ListFieldsToDisable(lIdx).BackColor = CL_COLOR_DISABLED
                        
                Case "ARMGRID", "ARMCHECKVIEW"
                                    
                Case "OPTIONBUTTON", "COMMANDBUTTON", "ARMCOMBOBOX", "ARMPICKER", "A_CALOCX", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TABSTRIP", "CHECKBOX"
                    av_ListFieldsToDisable(lIdx).Enabled = False
                    
                Case Else
                    Debug.Print "DisableFrameParts " & UCase(TypeName(av_ListFieldsToDisable(lIdx)))
            End Select
    Next
    Exit Sub
ErrHandler:
    Call ErrorHandler("DisableFrameParts")
End Sub

Private Sub SetTreeDelayedMode(ByVal ab_Delayed As Boolean)
On Error GoTo ErrHandler
Dim ll_Index As Long
    
    tvw_Main.Visible = Not ab_Delayed
    cmd_TVReLoad.Visible = ab_Delayed
    mt_MainConfig.TreeDelayed = ab_Delayed
    grd_main.Visible = Not ab_Delayed
    grd_SPA_Detail.Visible = (Not ab_Delayed) And (grd_main.SelectedCount > 0)
    Exit Sub
ErrHandler:
    Call ErrorHandler("SetTreeDelayedMode")
End Sub

Private Function GetModeFromRole(ByVal as_Role As String) As eMode
On Error GoTo ErrHandler

    GetModeFromRole = emView
    
    Select Case as_Role
    Case "A"
        GetModeFromRole = emAdd
    Case "B"
        GetModeFromRole = emUpdate
    Case "C"
        GetModeFromRole = emDelete
    End Select
    Exit Function
ErrHandler:
    Call ErrorHandler("GetModeFromRole")
End Function

Private Function LoadTreeView(ByRef aTV As ArmTreeView, ByRef aTreeViewInfo As TTreeViewInfo) As Boolean
On Error GoTo ErrorHandler
    
    Call aTV.Clear
    
    If aTreeViewInfo.Levels > 0 Then
      aTV.Levels = aTreeViewInfo.Levels
      aTV.StartDemandLevel = 1
      aTV.SelectedImages = aTreeViewInfo.SelectedImages
      aTV.Images = aTreeViewInfo.Images
      aTV.NodeRequests = ApplyTVFilters(aTreeViewInfo.NodeRequest)
      aTV.FindRequests = ApplyTVFilters(aTreeViewInfo.FindRequest)
      aTV.GridRequests = aTreeViewInfo.GridRequest
      
      If Not aTV.LoadTree(LoadTypeChildsDemand) Then
          Call Err.Raise(ArmErr.CompFncFailed, "aTV.LoadTree", "")
      End If
    End If
    Exit Function
ErrorHandler:
    Call ErrorHandler("LoadTreeView")
End Function

Private Function GetTreeViewInfoFromDB(ByVal AScreenName As String, ByVal aTVCode As String) As TTreeViewInfo
On Error GoTo ErrHandler

    Dim lTreeView As TTreeViewInfo
    Dim lRequest As String
    Dim lCurs As Long, lIdx As Long, lCount As Long
    
    ' Get the data from the DB
    lRequest = "EXEC Treeview_Parameters_lst '" & AScreenName & "', '" & aTVCode & "'"
    lCurs = OpenSQLSafe(mo_Db, lRequest)
    
    lCount = mo_Db.RowCount(lCurs) - 1
    
    If lCount < 0 Then
        Call Err.Raise(ArmErr.InvalidValue, lRequest, "AScreenName=" & AScreenName & " lCount=" & lCount)
    End If
    
    ReDim lTreeView.NodeRequest(lCount)
    ReDim lTreeView.GridRequest(lCount)
    ReDim lTreeView.ExcelRequest(lCount)
    ReDim lTreeView.FindRequest(lCount)
    ReDim lTreeView.CountRequest(lCount)
    ReDim lTreeView.Images(lCount)
    ReDim lTreeView.SelectedImages(lCount)
    
    Dim lLevel As Long
    For lIdx = 0 To lCount
        lLevel = mo_Db.GetFields(lCurs, "TV_Level")
        lTreeView.NodeRequest(lLevel) = ReplaceCommonPlaceholders(mo_Db.GetFields(lCurs, "TV_NodeRequest"))
        lTreeView.GridRequest(lLevel) = mo_Db.GetFields(lCurs, "TV_GridRequest")
        lTreeView.FindRequest(lLevel) = ReplaceCommonPlaceholders(mo_Db.GetFields(lCurs, "TV_FindRequest"))
        lTreeView.Images(lLevel) = mo_Db.GetFields(lCurs, "TV_Images")
        lTreeView.SelectedImages(lLevel) = mo_Db.GetFields(lCurs, "TV_SelectedImages")
        mo_Db.Next (lCurs)
    Next
    
    lTreeView.TreeViewCode = aTVCode
    lTreeView.Levels = lCount + 1
    lTreeView.Loaded = True
    GetTreeViewInfoFromDB = lTreeView
    
    Call mo_Db.Close(lCurs)
    Exit Function
ErrHandler:
    Call mo_Db.Close(lCurs)
    Call ErrorHandler("GetTreeViewInfoFromDB")
End Function

' ************************************************************************************
' FRAMEWORK DB-ACCESS FUNCTIONS
' please do not change this code
' ************************************************************************************

' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If

On Error GoTo ErrHandler

    Dim lc_Data As Long
    lc_Data = ao_DB.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_DB.RowCount(lc_Data)
        End If
    End If

    OpenSQLSafe = lc_Data

    Exit Function

ErrHandler:

    Call ErrorHandler("OpenSQLSafe")

End Function


' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
' Params:
' ao_Db (Object)
' as_Request (String)
' al_RowAffectedCount (String)
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#End If
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_DB.ExecuteSQL(as_Request) Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise ArmCusErr.DuplicityDetected, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            Else
                Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            End If
        End If
    End If

    Exit Sub

ErrHandler:
    Call ErrorHandler("ExecuteSQLSafe")
End Sub

Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo ErrHandler
    
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(mo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetDbError()")
End Function
' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    
    Call LogMessage(SCREEN_NAME & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_errDescription & ".", "E", False)
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, , App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' logs message to database
Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "E", Optional ab_ExitOnException As Boolean = False)
    Dim ll_errNumber As Long
    Dim ls_errDescription As String, ls_ErrSource As String
    
    ll_errNumber = Err.Number
    ls_errDescription = Err.Description
    ls_ErrSource = Err.Source

On Error GoTo ErrHandler

Const LOG_REQUEST As String = "EXEC A_log_ins $UCODE$,$LOGTYPE$,$MSG$,$APP$"
    Dim ls_req As String
    Dim ll_cursor As Long
    Dim ls_Source As String, ls_Msg As String
    
    ls_Source = SCREEN_NAME & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    ls_Msg = as_logMsg & SEP1 & ll_errNumber & " : " & ls_errDescription & " - " & ls_ErrSource
    
    ls_req = ReplacePlaceHolder(LOG_REQUEST, "$UCODE$", CStr(ml_U_Code))
    ls_req = ReplacePlaceHolder(ls_req, "$LOGTYPE$", SQLStr(as_logType))
    ls_req = ReplacePlaceHolder(ls_req, "$MSG$", Left(Trim(SQLStr(ls_Msg)), 4000))
    ls_req = ReplacePlaceHolder(ls_req, "$APP$", Left(Trim(SQLStr(ls_Source)), 50))
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Err.Number = ll_errNumber
    Err.Description = ls_errDescription
    Err.Source = ls_ErrSource
    Exit Sub
    
ErrHandler:
    If ab_ExitOnException Then
        Call MsgBox("A fatal error occured. Unable to log error into database, the application will be close. Please report the following message to your IT support: " & vbCrLf & _
            "Number:" & Err.Number & vbCrLf & "Description:" & Err.Description, , App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
        End
    End If
    Err.Number = ll_errNumber
    Err.Description = ls_errDescription
    Err.Source = ls_ErrSource
End Sub


' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate UserControl.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        UserControl.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    Exit Sub
ErrHandler:
    Call ErrorHandler("LockScreen")
End Sub

Private Function BeginTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    BeginTran = False
    ExecuteSQLSafe mo_Db, "BEGIN TRANSACTION " & as_Tran

    BeginTran = True
    Exit Function
    
ErrHandler:
    'try to log error
    Call LogMessage("BeginTran: " & as_Tran)
    Call mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".BeginTran, your application will be close. Please contact your IT support", , App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    End
End Function

Private Function CommitTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    CommitTran = False
    ExecuteSQLSafe mo_Db, "COMMIT TRANSACTION " & as_Tran

    CommitTran = True
    Exit Function
    
ErrHandler:
    'try to log error
    Call LogMessage("CommitTran: " & as_Tran)
    Call mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".CommitTran, your application will be close. Please contact your IT support", , App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    End

End Function

Private Function RollbackTran(as_Tran As String) As Boolean
    
    Dim ll_errNumber As Long, ls_ErrSource As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSource = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    RollbackTran = False
    
    ExecuteSQLSafe mo_Db, "ROLLBACK TRANSACTION " & as_Tran


    Err.Number = ll_errNumber
    Err.Source = ls_ErrSource
    Err.Description = ls_ErrDesc

    RollbackTran = True
    Exit Function
    
ErrHandler:
    'try to log error
    Call LogMessage("RollbackTran: " & as_Tran)
    Call mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".RollbackTran, your application will be close. Please contact your IT support", , App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    End
End Function

' ************************************************************************************
' *************************** INTERNATIONAL FUNCTIONS ********************************
' ************************************************************************************

Private Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal as_Language As String) As Long
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT Code_Page FROM Language WHERE Language_Code = '$Language_Code$'"
    Dim ls_req As String
    Dim ll_cursor As Long
    Dim ll_codePage As Long
    
    ls_req = ReplacePlaceHolder(C_REQ, "$Language_Code$", as_Language)

    ll_cursor = OpenSQLSafe(ao_Armdb, ls_req)
    Debug.Assert (ll_cursor <> 0)
    
    ll_codePage = CLng(ao_Armdb.GetFields(ll_cursor, "Code_Page"))
    Call ao_Armdb.Close(ll_cursor)
    GetCodePageFromLanguage = ll_codePage
    Exit Function
    
ErrHandler:
    If ll_cursor <> 0 Then Call ao_Armdb.Close(ll_cursor)
    Call ErrorHandler("GetCodePageFromLanguage()")
End Function

'convert code page into charset integer
Private Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long

On Error GoTo ErrHandler

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetCharSetFromCodePage()")
End Function

Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)

On Error GoTo ErrHandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0", "ARMPICKER"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("ChangeCharset")
End Sub

' Load the labels of a containers
Private Sub LoadLabels(ByRef ao_Armdb As ArmDb, ByRef ao_Container As Object, ByVal as_ScreenName As String, ByVal as_Language As String)
Dim lo_Control As Control   ' A control of the container
Dim li_Idx As Integer, li_Count As Integer
Dim li_Label As Integer      ' A label idx
Dim ls_Request As String
Dim lc_Labels As Long
Dim lsa_ControlTag() As String
    
    On Error GoTo Trace_Err

    If mc_ScreenLabels = 0 Then
        ls_Request = "exec screen_csts '" & as_ScreenName & "','" & as_Language & "'"
        mc_ScreenLabels = OpenSQLSafe(ao_Armdb, ls_Request)
    End If
    lc_Labels = mc_ScreenLabels
    
    If lc_Labels = 0 Then
        Exit Sub
    End If
    
    On Error GoTo WithoutTag
    If ao_Container.Tag <> "" Then
        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", ao_Container.Tag, , 1)
        If li_Label >= 0 Then
            ao_Container.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
        End If
    End If
WithoutTag:
    
    On Error GoTo Trace_Err
    
    ' Iterate the container for loading the label of each element which has defined a tag
    For Each lo_Control In UserControl.Controls
        If HasContainer(lo_Control, ao_Container) Then
            Select Case UCase(TypeName(lo_Control))
                Case UCase("TabStrip") ' Component is a tabstrip, we load the caption of each tab defined
                    Dim lo_Tbs
                    Set lo_Tbs = lo_Control ' Cast for use of intellisense
                    li_Count = lo_Tbs.Tabs.Count
                    For li_Idx = 1 To li_Count
                        If lo_Tbs.Tabs(li_Idx).Tag <> "" Then
                            li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Tbs.Tabs(li_Idx).Tag, , 1)
                            If li_Label >= 0 Then
                                lo_Tbs.Tabs(li_Idx).Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                            End If
                        End If
                    Next
                    Set lo_Tbs = Nothing
                
                Case UCase("ListView") ' Component is a listview, we load the caption of each columns
                    Dim lo_ListView As ListView
                    Set lo_ListView = lo_Control
                    li_Count = lo_ListView.ColumnHeaders.Count
                    For li_Idx = 1 To li_Count
                        If lo_ListView.ColumnHeaders(li_Idx).Tag <> "" Then
                            li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_ListView.ColumnHeaders(li_Idx).Tag, , 1)
                            If li_Label >= 0 Then
                                lo_ListView.ColumnHeaders(li_Idx).Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                            End If
                        End If
                    Next
                    Set lo_ListView = Nothing
            
                Case UCase("TextBox")  ' Component is a textbox
                    Dim lo_TextBox As TextBox
                    Set lo_TextBox = lo_Control
                    If lo_TextBox.Tag <> "" Then
                        lsa_ControlTag = Split(lo_Control.Tag, SEP)
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lsa_ControlTag(0), , 1)
                        If li_Label >= 0 Then
                            lo_TextBox.Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                    Set lo_TextBox = Nothing
                
                Case UCase("Label"), UCase("Frame"), UCase("CommandButton"), UCase("CheckBox"), UCase("OptionButton")
                    If lo_Control.Tag <> "" Then
                        lsa_ControlTag = Split(lo_Control.Tag, SEP)
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lsa_ControlTag(0), , 1)
                        If li_Label >= 0 Then
                            lo_Control.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                Case UCase("ArmGrid")
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag, , 1)
                    If li_Label >= 0 Then
                      Call lo_Control.LoadConstants(ptStatic, ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT"), ctColumns)
                    End If
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag & "_Title", , 1)
                    If li_Label >= 0 Then
                      lo_Control.Title = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                    End If
                Case UCase("Menu")
                    If lo_Control.Name <> "" Then
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Name, , 1)
                        If li_Label >= 0 Then
                            lo_Control.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
            End Select
        End If
    Next
        
Trace_End:
    Exit Sub
    
Trace_Err:
      
End Sub

Function MsgText(ByVal aID As Long, ByVal aLang As String, ByVal aDefault As String, Optional ByVal aInfo As Variant) As String
On Error GoTo ErrHandler

Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = ReplacePlaceHolder(DB_REQ, "$id$", aID)
    lRequest = ReplacePlaceHolder(lRequest, "$lang$", aLang)
    Dim lData As Long
    
    lData = OpenSQLSafe(mo_Db, lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    Dim li_Idx As Integer
    If Not IsMissing(aInfo) Then
        For li_Idx = 0 To UBound(aInfo)
            lBuffer = Replace(lBuffer, aInfo(li_Idx, 0), aInfo(li_Idx, 1), , , vbTextCompare)
        Next li_Idx
    End If
    
    
    MsgText = lBuffer
    Exit Function
ErrHandler:
    mo_Db.Close (lData)
    Call MsgBox("Connection failure accessing message information.", , App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    MsgText = aDefault
End Function

Private Function LoadIconFromA_Icons(ai_IconIndex As Integer) As Picture
Dim hIcon As Long
Dim hInst As Long
Dim oNewPic As Picture
Dim tPicConv As PictDesc
Dim IGuid As Guid

On Error GoTo ErrHandler
  
    hInst = LoadLibrary("c:\arm_apps\dll\A_icons.dll")
    If hInst = 0 Then
      Set LoadIconFromA_Icons = Nothing
      Exit Function
    End If
    
    hIcon = LoadIconFromDLL(hInst, ai_IconIndex)
    If hIcon = 0 Then
      Set LoadIconFromA_Icons = Nothing
      Exit Function
    End If
      
    With tPicConv
      .cbSizeofStruct = Len(tPicConv)
      .picType = vbPicTypeIcon
      .hImage = hIcon
    End With
     
    ' Fill in magic IPicture GUID {7BF80980-BF32-101A-8BBB-00AA00300CAB}
    With IGuid
          .Data1 = &H7BF80980
          .Data2 = &HBF32
          .Data3 = &H101A
          .Data4(0) = &H8B
          .Data4(1) = &HBB
          .Data4(2) = &H0
          .Data4(3) = &HAA
          .Data4(4) = &H0
          .Data4(5) = &H30
          .Data4(6) = &HC
          .Data4(7) = &HAB
    End With
    OleCreatePictureIndirect tPicConv, IGuid, True, oNewPic
      
    Set LoadIconFromA_Icons = oNewPic
    Call FreeLibrary(hInst)
    Exit Function
ErrHandler:
    Call FreeLibrary(hInst)
    Call ErrorHandler("LoadIconFromFile")
End Function

' ************************************************************************************
' **************************** REDIM FUNCTION ****************************************
' ************************************************************************************
Private Sub SafeRedimString(ByRef as_Array() As String, al_NumElements As Long)

On Error GoTo ErrHandler

  If al_NumElements = 0 Then
          ReDim as_Array(-1 To -1)
  Else
          'MS REDIMM
          Call SafeRedimPreserve(as_Array, al_NumElements - 1)
  End If
  Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SafeRedimString()")
End Sub


Private Function GetTempDir() As String
Dim ls_Buff As String, ll_Count As Long

On Error GoTo ErrHandler
    ls_Buff = Space(4096)
    ll_Count = GetTempPath(4096, ls_Buff)
    
    ls_Buff = Left(ls_Buff, ll_Count)
    'this function can return path with trailing "\" character - strip it
    If ll_Count > 0 Then
      If right(ls_Buff, 1) = "\" Then
       ls_Buff = Left(ls_Buff, ll_Count - 1)
      End If
    End If
    GetTempDir = ls_Buff
  Exit Function
ErrHandler:
  Call ErrorHandler("GetTempDir")
End Function

Private Function LoadUserInfo(ByRef ao_Armdb As Object, ByVal al_U_Code As Long) As String
On Error GoTo ErrHandler
Const C_REQ As String = _
    "SELECT GPL.P_Name + ' '+ GPL.P_First_Name as User_Name " & _
    "FROM GEN_Systems_Users GSU " & _
    "INNER JOIN GEN_People GPL ON (GSU.P_Code=GPL.P_Code) " & _
    "WHERE GSU.U_Code=$U_Code$"

Dim ls_req As String
Dim ll_cursor As Long
    
    ls_req = ReplacePlaceHolder(C_REQ, "$U_Code$", al_U_Code)
    ll_cursor = OpenSQLSafe(ao_Armdb, ls_req, 1)
    LoadUserInfo = ao_Armdb.GetFields(ll_cursor, "User_Name")
    Call ao_Armdb.Close(ll_cursor)
    Exit Function
    
ErrHandler:
    If ll_cursor <> 0 Then Call ao_Armdb.Close(ll_cursor)
    Call ErrorHandler("LoadUserInfo()")
End Function


Private Function InitUserRights(ByVal al_U_Code As Long) As Boolean
On Error GoTo ErrHandler
    Const C_REQ1 As String = "EXEC SPA_AuthMarket_rights_lst $U_Code$"
    Const C_REQ2 As String = "EXEC SPA_Approver_rights_lst $U_Code$"
    Dim ls_req As String
    Dim ll_cursor As Long
    Dim ll_i As Long
    
    InitUserRights = False
    
    mo_userRghts.U_Code = al_U_Code
    
    ls_req = ReplacePlaceHolder(C_REQ1, "$U_Code$", al_U_Code)
    ll_cursor = OpenSQLSafe(mo_Db, ls_req)
    
    If mo_Db.RowCount(ll_cursor) > 0 Then
        ReDim mo_userRghts.SPARights(0 To mo_Db.RowCount(ll_cursor) - 1) As TSPARight
        For ll_i = 0 To mo_Db.RowCount(ll_cursor) - 1
            mo_userRghts.SPARights(ll_i).SPM_Code = mo_Db.GetFields(ll_cursor, "SPM_Code")
            mo_userRghts.SPARights(ll_i).SPM_Desc = mo_Db.GetFields(ll_cursor, "SPM_Desc")
            mo_userRghts.SPARights(ll_i).SPA_UserType_Code = mo_Db.GetFields(ll_cursor, "SPA_UserType_Code")
            mo_userRghts.SPARights(ll_i).SPA_UserType_Desc = mo_Db.GetFields(ll_cursor, "SPA_UserType_Desc")
            Call mo_Db.Next(ll_cursor)
        Next
    Else
        ReDim mo_userRghts.SPARights(-1 To -1) As TSPARight
    End If
    
    Call mo_Db.Close(ll_cursor)
    
    ls_req = ReplacePlaceHolder(C_REQ2, "$U_Code$", al_U_Code)
    ll_cursor = OpenSQLSafe(mo_Db, ls_req)
    
    If mo_Db.RowCount(ll_cursor) > 0 Then
        ReDim mo_userRghts.SPAApproverRight(0 To mo_Db.RowCount(ll_cursor) - 1) As TSPAApproverRight
        For ll_i = 0 To mo_Db.RowCount(ll_cursor) - 1
            mo_userRghts.SPAApproverRight(ll_i).SPGAM_Id = mo_Db.GetFields(ll_cursor, "SPGAM_Id")
            mo_userRghts.SPAApproverRight(ll_i).SPR_Code = mo_Db.GetFields(ll_cursor, "SPR_Code")
            mo_userRghts.SPAApproverRight(ll_i).SPR_Desc = mo_Db.GetFields(ll_cursor, "SPR_Desc")
            mo_userRghts.SPAApproverRight(ll_i).DiscountPercent = mo_Db.GetFields(ll_cursor, "DiscountPercent")
            mo_userRghts.SPAApproverRight(ll_i).SPM_Code = mo_Db.GetFields(ll_cursor, "SPM_Code")
            mo_userRghts.SPAApproverRight(ll_i).SPM_Desc = mo_Db.GetFields(ll_cursor, "SPM_Desc")
            mo_userRghts.SPAApproverRight(ll_i).SPG_Code = mo_Db.GetFields(ll_cursor, "SPG_Code")
            mo_userRghts.SPAApproverRight(ll_i).SPG_Desc = mo_Db.GetFields(ll_cursor, "SPG_Desc")
            Call mo_Db.Next(ll_cursor)
        Next
    Else
        ReDim mo_userRghts.SPAApproverRight(-1 To -1) As TSPAApproverRight
    End If
    
    Call mo_Db.Close(ll_cursor)
    
    InitUserRights = ((LBound(mo_userRghts.SPARights) = 0) Or (LBound(mo_userRghts.SPAApproverRight) = 0))
    
    Exit Function
ErrHandler:
    If ll_cursor <> 0 Then Call mo_Db.Close(ll_cursor)
    Call ErrorHandler("InitUserRights()")
End Function




















Public Function ScanControls() As Boolean
On Error GoTo ErrHandler
    Dim lc_Control As Control
    Dim li_Counter As Integer
    Dim ls_StringBuilder As String
    Dim ll_Index As Long
    
    For Each lc_Control In UserControl.Controls
        'label
        If TypeOf lc_Control Is Label Then
            ll_Index = -1
            On Error Resume Next
            ll_Index = lc_Control.Index
            If ll_Index = -1 Then
                Debug.Print (UserControl.Name & ";" & lc_Control.Tag & ";E;E;;" & lc_Control.Caption)
            Else
                Debug.Print (UserControl.Name & ";" & lc_Control.Tag & ";E;E;;" & lc_Control.Caption)
            End If
        End If
        'check box
        If TypeOf lc_Control Is CheckBox Then
            Debug.Print (UserControl.Name & ";" & lc_Control.Tag & ";E;E;;" & lc_Control.Caption)
        End If
        'tabstrip
        If TypeOf lc_Control Is TabStrip Then
            For li_Counter = 1 To lc_Control.Tabs.Count
                Debug.Print (UserControl.Name & ";" & lc_Control.Tabs.Item(li_Counter).Tag & ";E;E;;" & lc_Control.Tabs.Item(li_Counter).Caption)
            Next
        End If
        'option button
        If TypeOf lc_Control Is OptionButton Then
            Debug.Print (UserControl.Name & ";" & lc_Control.Tag & ";E;E;;" & lc_Control.Caption)
        End If
        'grid
        If TypeOf lc_Control Is ArmGrid Then
            Debug.Print (UserControl.Name & ";" & lc_Control.Tag & "_Title;E;E;;" & lc_Control.Title)
            If Not lc_Control.Cols = 0 Then
                ls_StringBuilder = ""
                For li_Counter = 0 To lc_Control.Cols - 1
                    If li_Counter = lc_Control.Cols - 1 Then
                        ls_StringBuilder = ls_StringBuilder & lc_Control.Columns(li_Counter).Title
                    Else
                        ls_StringBuilder = ls_StringBuilder & lc_Control.Columns(li_Counter).Title & SEP
                    End If
                Next
                Debug.Print (UserControl.Name & ";" & lc_Control.Tag & ";E;E;;" & ls_StringBuilder)
            End If
        End If
    Next
    ScanControls = True
    
    Exit Function
ErrHandler:
    ScanControls = False
    Call ErrorHandler("ScanControls")
End Function

Private Sub EmailSPA(ByVal av_SPAKey As Variant, ByVal as_CT_Code As String, ByVal as_EMail As String)
Dim lb_EmailOK As Boolean
On Error GoTo ErrHandler
    
    Do
        as_EMail = InputBox(MsgText(0, ms_Language_Code, "#Do you want to send SPA with Mail to"), , as_EMail)
        If as_EMail = "" Then
            Exit Sub
        End If
        ' check validity of e_mail address entered
        lb_EmailOK = IsEmailValid(as_EMail)
        If Not lb_EmailOK Then
            ' M150
            Call MsgBox(MsgText(ErrMsg_M150, ms_Language_Code, "#M150 - This email address does not appear to be the correct format (User@domain)."))
            lb_EmailOK = False
        Else
            ' check the length of e-mail address entered
            lb_EmailOK = (Len(as_EMail) <= 80)
            If Not lb_EmailOK Then
                ' M730
                Call MsgBox(MsgText(ErrMsg_M730, ms_Language_Code, "#M730 - Length of address cannot be more than 80 characters."))
            End If
        End If
        
    Loop Until lb_EmailOK

    Call PrintSPA(av_SPAKey, as_CT_Code, as_EMail, False)
    Exit Sub
ErrHandler:
    Call ErrorHandler("EmailSPA")
End Sub

Private Sub PrintSPA(ByVal av_SPAKey As Variant, ByVal as_CT_Code As String, Optional ByVal as_EMail As String = "", Optional ab_preview As Boolean = False)
On Error GoTo ErrHandler
    
    Dim lo_Form As frmPrintSPA
    
    Set lo_Form = New frmPrintSPA
    
    If lo_Form.InitForm Then
        
    Set lo_Form.DB = mo_Db
    lo_Form.Language_Code = ms_Language_Code
    lo_Form.CT_Code = as_CT_Code
    lo_Form.EMail = as_EMail
    lo_Form.U_Code = ml_U_Code
    lo_Form.LoginName = ms_LoginName
    
    Call lo_Form.Load_A_COM
    
    Call lo_Form.Run(IIf(ab_preview, SPA_Mode.emUpdate, SPA_Mode.emAdd), av_SPAKey)
    
        Call lo_Form.Unload_A_COM
'    Unload (lo_form)
    Else
        Call Err.Raise(ArmErr.CompFncFailed, "lo_Form.InitForm", "failed")
    End If
    Set lo_Form = Nothing
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("PrintSPA")
End Sub


Private Function IsEmailValid(ByVal as_EmailText As String) As Boolean
On Error GoTo ErrHandler

Dim ls_Email
Dim las_Email() As String
Dim ll_Index As Long

IsEmailValid = True

  If Trim(as_EmailText) <> "" Then
    las_Email = Split(Replace(Trim(as_EmailText), ";", ","), ",")
    For ll_Index = 0 To UBound(las_Email)
      ls_Email = Trim(las_Email(ll_Index))
      If InStr(1, ls_Email, "/") Then
        If CheckLotusEmailFormat(ls_Email) = False Then
            IsEmailValid = False
            Exit Function
        End If
      Else
        If CheckNormalEmailFormat(ls_Email) = False Then
            IsEmailValid = False
            Exit Function
        End If
      End If
    Next
  End If
  Exit Function

ErrHandler:
    Call ErrorHandler("IsEmailValid")
End Function

Private Function CheckLotusEmailFormat(ByVal as_EmailCheck As String) As Boolean
On Error GoTo ErrHandler

Dim lb_CK As Boolean
Dim ll_Index As Long
Dim ll_Index2 As Long
Dim las_EmailParts() As String
Dim ls_EmailPart As String
Const sInvalidChars As String = "@"

    lb_CK = True
    
    las_EmailParts = Split(Trim(as_EmailCheck), "/")
    
    If UBound(las_EmailParts) < 2 Then
        lb_CK = False
        GoTo ExitFunction
    End If
    
    For ll_Index = 0 To UBound(las_EmailParts)
        ls_EmailPart = Trim(las_EmailParts(ll_Index))
        If Trim(ls_EmailPart) = "" Then
            lb_CK = False
            GoTo ExitFunction
        End If
        
        ' Check for invalid characters.
        If Len(as_EmailCheck) > Len(sInvalidChars) Then
            For ll_Index2 = 1 To Len(sInvalidChars)
                If InStr(as_EmailCheck, Mid(sInvalidChars, ll_Index2, 1)) > 0 Then
                    lb_CK = False
                    GoTo ExitFunction
                End If
            Next
        Else
            For ll_Index2 = 1 To Len(as_EmailCheck)
                If InStr(sInvalidChars, Mid(as_EmailCheck, ll_Index2, 1)) > 0 Then
                    lb_CK = False
                    GoTo ExitFunction
                End If
            Next
        End If
    
    Next
    
ExitFunction:
    CheckLotusEmailFormat = lb_CK
    Exit Function

ErrHandler:
    CheckLotusEmailFormat = False
    Call ErrorHandler("CheckLotusEmailFormat")

End Function

Private Function CheckNormalEmailFormat(ByVal as_EmailCheck As String) As Boolean
On Error GoTo ErrHandler

Dim lb_CK As Boolean
Dim ls_DomainType As String
Const sInvalidChars As String = "!#$%^&*()=+{}[]|\;:'/?>,< "
Dim ll_Index As Long

    lb_CK = Not InStr(1, as_EmailCheck, Chr(34)) > 0 'Check to see if there is a double quote
    If Not lb_CK Then GoTo ExitFunction
    
    lb_CK = Not InStr(1, as_EmailCheck, "..") > 0 'Check to see if there are consecutive dots
    If Not lb_CK Then GoTo ExitFunction
    
    ' Check for invalid characters.
    If Len(as_EmailCheck) > Len(sInvalidChars) Then
        For ll_Index = 1 To Len(sInvalidChars)
            If InStr(as_EmailCheck, Mid(sInvalidChars, ll_Index, 1)) > 0 Then
                lb_CK = False
                GoTo ExitFunction
            End If
        Next
    Else
        For ll_Index = 1 To Len(as_EmailCheck)
            If InStr(sInvalidChars, Mid(as_EmailCheck, ll_Index, 1)) > 0 Then
                lb_CK = False
                GoTo ExitFunction
            End If
        Next
    End If
    
    If InStr(1, as_EmailCheck, "@") > 1 Then 'Check for an @ symbol
        lb_CK = Len(Left(as_EmailCheck, InStr(1, as_EmailCheck, "@") - 1)) > 0
        Else
        lb_CK = False
        End If
    If Not lb_CK Then GoTo ExitFunction
    
    as_EmailCheck = right(as_EmailCheck, Len(as_EmailCheck) - InStr(1, as_EmailCheck, "@"))
    lb_CK = Not InStr(1, as_EmailCheck, "@") > 0 'Check to see if there are too many @'s
    If Not lb_CK Then GoTo ExitFunction
    
    If InStr(1, as_EmailCheck, ".") = 0 Then
        lb_CK = False
        GoTo ExitFunction
    End If

    ls_DomainType = right(as_EmailCheck, Len(as_EmailCheck) - InStr(1, as_EmailCheck, "."))
    lb_CK = Len(ls_DomainType) > 0 And InStr(1, as_EmailCheck, ".") < Len(as_EmailCheck)
    If Not lb_CK Then GoTo ExitFunction
    
    as_EmailCheck = Left(as_EmailCheck, Len(as_EmailCheck) - Len(ls_DomainType) - 1)
    Do Until InStr(1, as_EmailCheck, ".") <= 1
        If Len(as_EmailCheck) >= InStr(1, as_EmailCheck, ".") Then
            as_EmailCheck = Left(as_EmailCheck, Len(as_EmailCheck) - (InStr(1, as_EmailCheck, ".") - 1))
        Else
            lb_CK = False
            GoTo ExitFunction
        End If
    Loop
    If as_EmailCheck = "." Or Len(as_EmailCheck) = 0 Then lb_CK = False
    
ExitFunction:
    CheckNormalEmailFormat = lb_CK
    Exit Function
    
ErrHandler:
    CheckNormalEmailFormat = False
    Call ErrorHandler("CheckNormalEmailFormat")
End Function


Private Sub Component_SetUp(ByVal ao_cpt As Object, ByVal as_Tag As String)

On Error GoTo ErrHandler
    
    ao_cpt.Tag = as_Tag
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Component_SetUp")
End Sub

